/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwarder;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitServer {
    private static final String GIT_SERVICE = "git";
    private static final String GIT_LOCALPORT = "10001";
    private static final String GIT_REMOTEPORT = "8080";
    private NamespacedKubernetesClient client;
    private String namespace;
    private Pod server;
    private PortForwarder forwarder;
    private Config config;
    private Service service;

    public GitServer(NamespacedKubernetesClient client, Config config, String namespace) {
        this.client = client;
        this.config = config;
        this.namespace = namespace;
    }

    public URI push(File source, String name) throws Exception {
        this.init();
        File gitRoot = new File("target", name);
        FileUtils.copyDirectory((File)source, (File)gitRoot);
        String repoUrl = String.format("http://localhost:%s/%s", GIT_LOCALPORT, name);
        Git git = Git.init().setDirectory(gitRoot).call();
        Repository repo = git.getRepository();
        repo.getConfig().setString("remote", "origin", "url", repoUrl);
        repo.getConfig().save();
        git.add().addFilepattern(".").call();
        git.commit().setMessage("testing").setAuthor("Arquillian", "cube@discuss.arquillian.org").call();
        git.push().setRemote("origin").setPushAll().setForce(true).call();
        repo.close();
        String serverUrl = String.format("http://%s:%s/%s", GIT_SERVICE, GIT_REMOTEPORT, name);
        return URI.create(serverUrl);
    }

    public void shutdown() throws Exception {
        if (this.forwarder != null) {
            this.forwarder.close();
        }
        if (this.service != null) {
            ((ClientResource)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(this.service.getMetadata().getName())).delete();
        }
        if (this.server != null) {
            ((ClientPodResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.server.getMetadata().getName())).delete();
            ((ClientResource)((ClientNonNamespaceOperation)this.client.secrets().inNamespace(this.namespace)).withName("gitserver-config")).delete();
        }
    }

    private void init() throws Exception {
        this.createService();
        if (this.server == null) {
            this.server = this.getSpec();
            this.server = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.server.getMetadata().getName())).get();
            if (this.server == null) {
                this.server = (Pod)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).create((Object[])new Pod[]{this.getSpec()});
                this.server = ResourceUtil.waitForStart((KubernetesClient)this.client, this.server);
            }
        }
        if (this.forwarder != null) {
            this.forwarder.close();
        }
        this.forwarder = new PortForwarder(this.config, this.server.getMetadata().getName());
        this.forwarder.forwardPort(Integer.valueOf(GIT_LOCALPORT).intValue(), Integer.valueOf(GIT_REMOTEPORT).intValue());
    }

    private Pod getSpec() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        labels.put("pod", "arquillian-gitserver");
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("arquillian-gitserver")).withLabels(labels)).endMetadata()).withNewSpec().addNewContainer().withName("arquillian-gitserver")).withImage("aslakknutsen/openshift-arquillian-gitserver")).addNewPort().withContainerPort(Integer.valueOf(GIT_REMOTEPORT))).endPort()).addNewEnv().withName("GIT_HOME")).withValue("/var/lib/git")).endEnv()).addNewVolumeMount().withName("git-repo")).withMountPath("/var/lib/git")).withReadOnly(Boolean.valueOf(false))).endVolumeMount()).endContainer()).addNewVolume().withName("git-repo")).withNewEmptyDir("Memory")).endVolume()).endSpec()).build();
    }

    private void createService() {
        if (this.service != null) {
            return;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        Service svc = (Service)((ClientResource)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(GIT_SERVICE)).get();
        if (svc == null) {
            svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(GIT_SERVICE)).withLabels(labels)).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(GIT_REMOTEPORT))).withNewTargetPort(Integer.valueOf(GIT_REMOTEPORT))).endPort()).addToSelector("pod", "arquillian-gitserver")).and()).build();
            ((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace)).create((Object[])new Service[]{svc});
        }
        this.service = svc;
    }
}

