/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.openshift.impl.client.GitServer;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.model.Template;

public class OpenShiftClient {
    private String namespace;
    private NamespacedKubernetesClient kubernetes;
    private GitServer gitserver;
    private boolean keepAliveGitServer;

    public OpenShiftClient(Config config, String namespace, boolean keepAliveGitServer) {
        this.kubernetes = new DefaultKubernetesClient(config);
        this.namespace = namespace;
        this.keepAliveGitServer = keepAliveGitServer;
        this.gitserver = new GitServer(this.getClient(), config, namespace);
    }

    public List<Exception> clean(ResourceHolder holder) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<HasMetadata> resourcesToDelete = new ArrayList<HasMetadata>();
        for (KubernetesResource resource : holder.getResources()) {
            if (!(resource instanceof HasMetadata)) continue;
            resourcesToDelete.add((HasMetadata)resource);
        }
        try {
            this.getClient().lists().delete((Object[])new KubernetesList[]{((KubernetesListBuilder)new KubernetesListBuilder().withItems(resourcesToDelete)).build()});
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        return exceptions;
    }

    public ResourceHolder build(Template<Pod> template) throws Exception {
        ResourceHolder holder = new ResourceHolder();
        Map<String, String> defaultLabels = this.getDefaultLabels();
        if (template.getRefs().size() == 0) {
            Pod service = this.createStartablePod(template, defaultLabels);
            holder.setPod(service);
            return holder;
        }
        for (Template.TemplateImageRef ref : template.getRefs()) {
            URI repoUri = this.gitserver.push(new File(ref.getPath()), ref.getContainerName());
            String runID = ref.getContainerName();
            try {
                Pod service = this.createStartablePod(template, defaultLabels);
                holder.setPod(service);
            }
            catch (Exception e) {
                holder.setException(e);
            }
        }
        return holder;
    }

    private Pod createStartablePod(Template<Pod> template, Map<String, String> defaultLabels) {
        HashMap<String, String> allLabels = new HashMap<String, String>();
        allLabels.putAll(defaultLabels);
        allLabels.putAll(template.getTarget().getMetadata().getLabels());
        Pod service = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadataLike(template.getTarget().getMetadata()).withLabels(allLabels)).endMetadata()).withNewSpecLike(template.getTarget().getSpec()).endSpec()).build();
        return service;
    }

    public Pod createAndWait(Pod resource) throws Exception {
        return ResourceUtil.waitForStart((KubernetesClient)this.getClient(), (Pod)((ClientNonNamespaceOperation)this.getClient().pods().inNamespace(this.namespace)).create((Object[])new Pod[]{resource}));
    }

    public Service create(Service resource) throws Exception {
        return (Service)((ClientNonNamespaceOperation)this.getClient().services().inNamespace(this.namespace)).create((Object[])new Service[]{resource});
    }

    public void destroy(Pod resource) throws Exception {
        ((ClientPodResource)((ClientNonNamespaceOperation)this.getClient().pods().inNamespace(this.namespace)).withName(resource.getMetadata().getName())).delete();
    }

    public void destroy(Service resource) throws Exception {
        ((ClientResource)((ClientNonNamespaceOperation)this.getClient().services().inNamespace(this.namespace)).withName(resource.getMetadata().getName())).delete();
    }

    public Pod update(Pod resource) throws Exception {
        return (Pod)this.getClient().resource((HasMetadata)resource).createOrReplace();
    }

    public void shutdown() throws Exception {
        if (!this.keepAliveGitServer) {
            this.gitserver.shutdown();
        }
    }

    public NamespacedKubernetesClient getClient() {
        return this.kubernetes;
    }

    public KubernetesClient getClientExt() {
        return this.kubernetes;
    }

    private Map<String, String> getDefaultLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        return labels;
    }

    public static class ResourceHolder {
        public Pod pod;
        public Set<KubernetesResource> resources;
        private Exception exception;

        public ResourceHolder() {
            this(null);
        }

        public ResourceHolder(Pod pod) {
            this.pod = pod;
            this.resources = new HashSet<KubernetesResource>();
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setPod(Pod pod) {
            this.pod = pod;
        }

        public void addResource(KubernetesResource resource) {
            this.resources.add(resource);
        }

        public Set<KubernetesResource> getResources() {
            if (this.resources == null) {
                return new HashSet<KubernetesResource>();
            }
            return this.resources;
        }

        public Pod getPod() {
            return this.pod;
        }
    }
}

