/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.namespace;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.impl.namespace.DefaultNamespaceService;

public class OpenshiftNamespaceService
extends DefaultNamespaceService {
    private static final String PROJECT_LABEL = "project";
    private static final String FRAMEWORK_LABEL = "framework";
    private static final String COMPONENT_LABEL = "component";
    private static final String ARQUILLIAN_FRAMEWORK = "arquillian";
    private static final String ITEST_COMPONENT = "integrationTest";

    public Namespace create(String namespace) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            ProjectRequest projectRequest = ((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(namespace)).addToLabels(((LabelProvider)this.labelProvider.get()).getLabels())).addToLabels(PROJECT_LABEL, client.getNamespace())).addToLabels(FRAMEWORK_LABEL, ARQUILLIAN_FRAMEWORK)).addToLabels(COMPONENT_LABEL, ITEST_COMPONENT)).endMetadata()).build();
            ProjectRequest request = (ProjectRequest)openShiftClient.projectrequests().create((Object[])new ProjectRequest[]{projectRequest});
            return (Namespace)((ClientResource)openShiftClient.namespaces().withName(request.getMetadata().getName())).get();
        }
        return super.create(namespace);
    }

    public Boolean delete(String namespace) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            return (Boolean)((ClientResource)openShiftClient.projects().withName(namespace)).delete();
        }
        return super.delete(namespace);
    }

    public Boolean exists(String namespace) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            try {
                return ((ClientResource)openShiftClient.projects().withName(namespace)).get() != null;
            }
            catch (KubernetesClientException e) {
                return false;
            }
        }
        return super.exists(namespace);
    }

    public void clean(String namespace) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            ((ClientNonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(namespace)).delete();
        }
        super.clean(namespace);
    }
}

