/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluentImpl;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfigurationFluent;

public class CubeOpenShiftConfigurationFluentImpl<A extends CubeOpenShiftConfigurationFluent<A>>
extends DefaultConfigurationFluentImpl<A>
implements CubeOpenShiftConfigurationFluent<A> {
    boolean keepAliveGitServer;
    String definitions;
    String definitionsFile;
    List<String> autoStartContainers = new ArrayList<String>();
    Set<String> proxiedContainerPorts = new LinkedHashSet<String>();
    String portForwardBindAddress;

    public CubeOpenShiftConfigurationFluentImpl() {
    }

    public CubeOpenShiftConfigurationFluentImpl(CubeOpenShiftConfiguration instance) {
        this.withSessionId(instance.getSessionId());
        this.withMasterUrl(instance.getMasterUrl());
        this.withNamespace(instance.getNamespace());
        this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl());
        this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl());
        this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl());
        this.withEnvironmentDependencies(instance.getEnvironmentDependencies());
        this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled());
        this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled());
        this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout());
        this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled());
        this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled());
        this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout());
        this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled());
        this.withWaitTimeout(instance.getWaitTimeout());
        this.withWaitPollInterval(instance.getWaitPollInterval());
        this.withWaitForServiceList(instance.getWaitForServiceList());
        this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled());
        this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled());
        this.withKubernetesDomain(instance.getKubernetesDomain());
        this.withDockerRegistry(instance.getDockerRegistry());
        this.withKeepAliveGitServer(instance.isKeepAliveGitServer());
        this.withDefinitions(instance.getDefinitions());
        this.withDefinitionsFile(instance.getDefinitionsFile());
        this.withAutoStartContainers(instance.getAutoStartContainers());
        this.withProxiedContainerPorts(instance.getProxiedContainerPorts());
        this.withPortForwardBindAddress(instance.getPortForwardBindAddress());
    }

    @Override
    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    @Override
    public A withKeepAliveGitServer(boolean keepAliveGitServer) {
        this.keepAliveGitServer = keepAliveGitServer;
        return (A)this;
    }

    @Override
    public String getDefinitions() {
        return this.definitions;
    }

    @Override
    public A withDefinitions(String definitions) {
        this.definitions = definitions;
        return (A)this;
    }

    @Override
    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    @Override
    public A withDefinitionsFile(String definitionsFile) {
        this.definitionsFile = definitionsFile;
        return (A)this;
    }

    @Override
    public A withAutoStartContainers(String ... autoStartContainers) {
        this.autoStartContainers.clear();
        if (autoStartContainers != null) {
            for (String item : autoStartContainers) {
                this.addToAutoStartContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getAutoStartContainers() {
        String[] result = new String[this.autoStartContainers.size()];
        int index = 0;
        for (String item : this.autoStartContainers) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToAutoStartContainers(String ... items) {
        for (String item : items) {
            this.autoStartContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAutoStartContainers(String ... items) {
        for (String item : items) {
            this.autoStartContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A addToProxiedContainerPorts(String ... items) {
        for (String item : items) {
            this.proxiedContainerPorts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromProxiedContainerPorts(String ... items) {
        for (String item : items) {
            this.proxiedContainerPorts.remove(item);
        }
        return (A)this;
    }

    @Override
    public Set<String> getProxiedContainerPorts() {
        return this.proxiedContainerPorts;
    }

    @Override
    public A withProxiedContainerPorts(Set<String> proxiedContainerPorts) {
        this.proxiedContainerPorts.clear();
        if (proxiedContainerPorts != null) {
            for (String item : proxiedContainerPorts) {
                this.addToProxiedContainerPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withProxiedContainerPorts(String ... proxiedContainerPorts) {
        this.proxiedContainerPorts.clear();
        if (proxiedContainerPorts != null) {
            for (String item : proxiedContainerPorts) {
                this.addToProxiedContainerPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }

    @Override
    public A withPortForwardBindAddress(String portForwardBindAddress) {
        this.portForwardBindAddress = portForwardBindAddress;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CubeOpenShiftConfigurationFluentImpl that = (CubeOpenShiftConfigurationFluentImpl)o;
        if (this.keepAliveGitServer != that.keepAliveGitServer) {
            return false;
        }
        if (this.definitions != null ? !this.definitions.equals(that.definitions) : that.definitions != null) {
            return false;
        }
        if (this.definitionsFile != null ? !this.definitionsFile.equals(that.definitionsFile) : that.definitionsFile != null) {
            return false;
        }
        if (this.autoStartContainers != null ? !this.autoStartContainers.equals(that.autoStartContainers) : that.autoStartContainers != null) {
            return false;
        }
        if (this.proxiedContainerPorts != null ? !this.proxiedContainerPorts.equals(that.proxiedContainerPorts) : that.proxiedContainerPorts != null) {
            return false;
        }
        return !(this.portForwardBindAddress != null ? !this.portForwardBindAddress.equals(that.portForwardBindAddress) : that.portForwardBindAddress != null);
    }
}

