/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitServer {
    private static int PORT = 6768;
    private Kubernetes client;
    private String namespace;
    private Pod server;

    public GitServer(Kubernetes client, String namespace) {
        this.client = client;
        this.namespace = namespace;
    }

    public URI push(File source, String name) throws Exception {
        this.init();
        URI server = this.getServerURI();
        String id = name;
        String repoUrl = server.toASCIIString() + "/" + id;
        File gitRoot = new File("target", id);
        FileUtils.copyDirectory((File)source, (File)gitRoot);
        Git git = Git.init().setDirectory(gitRoot).call();
        Repository repo = git.getRepository();
        repo.getConfig().setString("remote", "origin", "url", repoUrl);
        repo.getConfig().save();
        git.add().addFilepattern(".").call();
        git.commit().setMessage("testing").setAuthor("Arquillian", "cube@discuss.arquillian.org").call();
        git.push().setRemote("origin").setPushAll().setForce(true).call();
        repo.close();
        return URI.create(repoUrl);
    }

    public void shutdown() throws Exception {
        if (this.server != null) {
            this.client.deletePod(this.server.getMetadata().getName(), this.namespace);
            this.client.deleteSecret("gitserver-config", this.namespace);
        }
    }

    private void init() throws Exception {
        if (this.server == null) {
            this.server = this.getSpec();
            try {
                this.server = this.client.getPod(this.server.getMetadata().getName(), this.namespace);
            }
            catch (WebApplicationException e) {
                Object response = KubernetesHelper.loadJson((String)this.client.createPod(this.server, this.namespace));
                if (response instanceof Pod) {
                    this.server = (Pod)response;
                }
                throw new RuntimeException("Unknown response on gitserver deploy: " + this.server);
            }
            this.server = ResourceUtil.waitForStart(this.client, this.server);
        }
    }

    private URI getServerURI() {
        return URI.create("http://" + this.server.getStatus().getHostIP() + ":" + PORT);
    }

    private Pod getSpec() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("arquillian-gitserver")).withLabels(labels)).endMetadata()).withNewSpec().addNewContainer().withName("arquillian-gitserver")).withImage("aslakknutsen/openshift-arquillian-gitserver")).addNewPort().withHostPort(Integer.valueOf(PORT))).withContainerPort(Integer.valueOf(8080))).endPort()).addNewEnv().withName("GIT_HOME")).withValue("/var/lib/git")).endEnv()).endContainer()).endSpec()).build();
    }
}

