/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.openshift.impl.client.GitServer;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.model.Template;

public class OpenShiftClient {
    private KubernetesFactory factory;
    private String namespace;
    private Kubernetes kubernetes;
    private KubernetesExtensions kubernetesExtensions;
    private GitServer gitserver;
    private boolean keepAliveGitServer;

    public OpenShiftClient(KubernetesFactory factory, String namespace, boolean keepAliveGitServer) {
        this.factory = factory;
        this.namespace = namespace;
        this.keepAliveGitServer = keepAliveGitServer;
        this.gitserver = new GitServer(this.getClient(), namespace);
    }

    public List<Exception> clean(ResourceHolder holder) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (KubernetesResource resource : holder.getResources()) {
            try {
                Pod m;
                if (resource instanceof Pod) {
                    m = (Pod)resource;
                    this.getClient().deletePod(m.getMetadata().getName(), this.namespace);
                    continue;
                }
                if (resource instanceof ImageStream) {
                    m = (ImageStream)resource;
                    this.getClientExt().deleteImageStream(m.getMetadata().getName(), this.namespace);
                    continue;
                }
                if (resource instanceof BuildConfig) {
                    m = (BuildConfig)resource;
                    this.getClientExt().deleteBuildConfig(m.getMetadata().getName(), this.namespace);
                    continue;
                }
                if (!(resource instanceof Build)) continue;
                Build build = (Build)resource;
                this.getClientExt().deleteBuild(build.getMetadata().getName(), this.namespace);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public ResourceHolder build(Template<Pod> template) throws Exception {
        ResourceHolder holder = new ResourceHolder();
        Map<String, String> defaultLabels = this.getDefaultLabels();
        if (template.getRefs().size() == 0) {
            Pod service = this.createStartablePod(template, defaultLabels);
            holder.setPod(service);
            return holder;
        }
        for (Template.TemplateImageRef ref : template.getRefs()) {
            URI repoUri = this.gitserver.push(new File(ref.getPath()), ref.getContainerName());
            String runID = ref.getContainerName();
            try {
                ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(runID)).withLabels(defaultLabels)).endMetadata()).build();
                is = (ImageStream)KubernetesHelper.loadJson((String)this.getClientExt().createImageStream(is, this.namespace));
                holder.addResource((KubernetesResource)is);
                BuildConfig config = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(runID)).withLabels(defaultLabels)).endMetadata()).withNewSpec().withNewSource().withNewGit("master", repoUri.toString())).withType("Git")).endSource()).withNewStrategy().withType("Docker")).withNewDockerStrategy().withNoCache(Boolean.valueOf(false))).endDockerStrategy()).endStrategy()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(runID + ":latest")).endTo()).endOutput()).endSpec()).build();
                config = (BuildConfig)KubernetesHelper.loadJson((String)this.getClientExt().createBuildConfig(config, this.namespace));
                holder.addResource((KubernetesResource)config);
                BuildRequest br = ((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(config.getMetadata().getName())).withLabels(defaultLabels)).endMetadata()).build();
                Build build = ResourceUtil.waitForComplete(this.getClientExt(), (Build)KubernetesHelper.loadJson((String)this.getClientExt().instantiateBuild(config.getMetadata().getName(), br, this.namespace)));
                holder.addResource((KubernetesResource)build);
                is = this.getClientExt().getImageStream(is.getMetadata().getName(), this.namespace);
                String imageRef = ((TagEvent)((NamedTagEventList)is.getStatus().getTags().get(0)).getItems().get(0)).getDockerImageReference();
                template.resolve(ref, imageRef);
                Pod service = this.createStartablePod(template, defaultLabels);
                holder.setPod(service);
            }
            catch (Exception e) {
                holder.setException(e);
            }
        }
        return holder;
    }

    private Pod createStartablePod(Template<Pod> template, Map<String, String> defaultLabels) {
        HashMap<String, String> allLabels = new HashMap<String, String>();
        allLabels.putAll(defaultLabels);
        allLabels.putAll(template.getTarget().getMetadata().getLabels());
        Pod service = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadataLike(template.getTarget().getMetadata()).withLabels(allLabels)).endMetadata()).withNewSpecLike(template.getTarget().getSpec()).endSpec()).build();
        return service;
    }

    public Pod createAndWait(Pod resource) throws Exception {
        return ResourceUtil.waitForStart(this.getClient(), (Pod)KubernetesHelper.loadJson((String)this.getClient().createPod(resource, this.namespace)));
    }

    public Service create(Service resource) throws Exception {
        return (Service)KubernetesHelper.loadJson((String)this.getClient().createService(resource, this.namespace));
    }

    public void destroy(Pod resource) throws Exception {
        this.getClient().deletePod(resource.getMetadata().getName(), this.namespace);
    }

    public void destroy(Service resource) throws Exception {
        this.getClient().deleteService(resource.getMetadata().getName(), this.namespace);
    }

    public Pod update(Pod resource) throws Exception {
        return this.getClient().getPod(resource.getMetadata().getName(), this.namespace);
    }

    public void shutdown() throws Exception {
        if (!this.keepAliveGitServer) {
            this.gitserver.shutdown();
        }
    }

    public Kubernetes getClient() {
        if (this.kubernetes == null) {
            this.kubernetes = this.factory.createKubernetes();
        }
        return this.kubernetes;
    }

    public KubernetesExtensions getClientExt() {
        if (this.kubernetesExtensions == null) {
            this.kubernetesExtensions = this.factory.createKubernetesExtensions();
        }
        return this.kubernetesExtensions;
    }

    private Map<String, String> getDefaultLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        return labels;
    }

    public static class ResourceHolder {
        public Pod pod;
        public Set<KubernetesResource> resources;
        private Exception exception;

        public ResourceHolder() {
            this(null);
        }

        public ResourceHolder(Pod pod) {
            this.pod = pod;
            this.resources = new HashSet<KubernetesResource>();
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setPod(Pod pod) {
            this.pod = pod;
        }

        public void addResource(KubernetesResource resource) {
            this.resources.add(resource);
        }

        public Set<KubernetesResource> getResources() {
            if (this.resources == null) {
                return new HashSet<KubernetesResource>();
            }
            return this.resources;
        }

        public Pod getPod() {
            return this.pod;
        }
    }
}

