/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.Service;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.ChangeLog;
import org.arquillian.cube.TopContainer;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;

public class ServiceCube
implements Cube {
    private String id;
    private Service resource;
    private Cube.State state;
    private CubeOpenShiftConfiguration configuration;
    private OpenShiftClient client;
    private OpenShiftClient.ResourceHolder holder;

    public ServiceCube(Service resource, OpenShiftClient client, CubeOpenShiftConfiguration configuration) {
        this.id = resource.getMetadata().getName();
        this.resource = resource;
        this.client = client;
        this.configuration = configuration;
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        this.state = Cube.State.CREATED;
    }

    public void start() throws CubeControlException {
        try {
            this.resource = this.client.create(this.resource);
            this.state = Cube.State.STARTED;
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.getId(), (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        try {
            this.client.destroy(this.resource);
            this.state = Cube.State.STOPPED;
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.getId(), (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        this.state = Cube.State.DESTROYED;
    }

    public boolean isRunningOnRemote() {
        return this.state == Cube.State.STARTED;
    }

    public void changeToPreRunning() {
    }

    public Binding bindings() {
        if (this.holder != null) {
            return ResourceUtil.toBinding(this.resource);
        }
        return null;
    }

    public Binding configuredBindings() {
        return ResourceUtil.toBinding(this.resource);
    }

    public Map<String, Object> configuration() {
        return new HashMap<String, Object>();
    }

    public List<ChangeLog> changesOnFilesystem(String cubeId) {
        return null;
    }

    public void copyFileDirectoryFromContainer(String cubeId, String from, String to) {
    }

    public void copyLog(String cubeId, boolean follow, boolean stdout, boolean stderr, boolean timestamps, int tail, OutputStream outputStream) {
    }

    public TopContainer top(String cubeId) {
        return null;
    }
}

