/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.KubernetesFactory;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;

public class OpenShiftClientCreator {
    @Inject
    @ApplicationScoped
    private InstanceProducer<OpenShiftClient> openShiftClientProducer;

    public void createClient(@Observes CubeOpenShiftConfiguration cubeConfiguration) {
        this.openShiftClientProducer.set((Object)this.createClient(cubeConfiguration.getOriginServer(), cubeConfiguration.getNamespace(), cubeConfiguration.shouldKeepAliveGitServer()));
    }

    public void clean(@Observes AfterSuite event, OpenShiftClient client) throws Exception {
        client.shutdown();
    }

    public OpenShiftClient createClient(String originServer, String namespace, boolean keepAliveGitServer) {
        System.setProperty("KUBERNETES_TRUST_CERT", "true");
        KubernetesFactory factory = new KubernetesFactory(originServer);
        return new OpenShiftClient(factory, namespace, keepAliveGitServer);
    }
}

