/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.requirement;

import io.fabric8.kubernetes.clnt.v4_0.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.utils.URLUtils;
import io.fabric8.openshift.clnt.v4_0.OpenShiftClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.ClientConfigBuilder;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.kubernetes.impl.ExtensionRegistrar;
import org.arquillian.cube.openshift.impl.requirement.RequiresOpenshift;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class OpenshiftRequirement
implements Constraint<RequiresOpenshift> {
    public void check(RequiresOpenshift context) throws UnsatisfiedRequirementException {
        List<String> extension = Arrays.asList("kubernetes", "openshift");
        DefaultConfiguration config = new ExtensionRegistrar().loadExtension(extension);
        DefaultKubernetesClient client = new DefaultKubernetesClient(new ClientConfigBuilder().configuration((Configuration)config).build());
        OkHttpClient httpClient = (OkHttpClient)client.adapt(OkHttpClient.class);
        Request versionRequest = new Request.Builder().get().url(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"})).build();
        try {
            Response response = httpClient.newCall(versionRequest).execute();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify Openshift version, due to: [" + response.message() + "]");
            }
            if (!client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                throw new UnsatisfiedRequirementException("A valid Kubernetes environmnet was found, but not Openshift.");
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedRequirementException("Error while checking Openshift version: [" + e.getMessage() + "]");
        }
    }
}

