/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.api.Template;
import org.arquillian.cube.openshift.api.model.DeploymentConfig;
import org.arquillian.cube.openshift.api.model.OpenShiftResource;
import org.arquillian.cube.openshift.impl.adapter.OpenShiftAdapter;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.resources.OpenShiftResourceFactory;
import org.arquillian.cube.openshift.impl.utils.Operator;
import org.arquillian.cube.openshift.impl.utils.ParamValue;
import org.arquillian.cube.openshift.impl.utils.StringResolver;
import org.arquillian.cube.openshift.impl.utils.Strings;
import org.arquillian.cube.openshift.impl.utils.TemplateUtils;
import org.jboss.arquillian.test.spi.TestClass;

public abstract class TemplateProcessor<T> {
    OpenShiftAdapter openShiftAdapter;
    protected CubeOpenShiftConfiguration configuration;
    TestClass testClass;
    List<Template> templates = Collections.emptyList();

    protected abstract T getType();

    protected abstract String templateKeyPrefix();

    public abstract List<Template> getTemplates();

    protected abstract String asynchronousDelayErrorMessage();

    protected abstract String noTemplateMessage();

    protected abstract Map<String, String> scopeLabels();

    protected abstract void handleExceptionForCreatingResource() throws Exception;

    protected abstract Logger logger();

    public List<? super OpenShiftResource> processTemplateResources() {
        ArrayList<OpenShiftResource> processedResources = new ArrayList<OpenShiftResource>();
        this.templates = OpenShiftResourceFactory.getTemplates(this.getType());
        boolean sync_instantiation = OpenShiftResourceFactory.syncInstantiation(this.getType());
        for (Template template : this.templates) {
            List<OpenShiftResource> resources = this.processTemplate(template);
            if (resources == null) continue;
            if (sync_instantiation) {
                processedResources.addAll(resources);
                continue;
            }
            try {
                this.delay(this.openShiftAdapter, resources);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(this.asynchronousDelayErrorMessage(), t);
            }
        }
        return processedResources;
    }

    private List<? extends OpenShiftResource> processTemplate(Template template) {
        StringResolver resolver = Strings.createStringResolver(this.configuration.getProperties());
        String templateURL = TemplateUtils.readTemplateUrl(template, this.configuration, false, resolver);
        Logger log = this.logger();
        if (templateURL == null) {
            log.info(this.noTemplateMessage());
            return null;
        }
        try {
            List<Object> resources;
            Map<String, String> readLabels = TemplateUtils.readLabels(template, this.configuration, resolver);
            if (readLabels.isEmpty()) {
                log.warning(String.format("Empty labels for template: %s, namespace: %s", templateURL, this.configuration.getNamespace()));
            }
            HashMap<String, String> labels = new HashMap<String, String>(readLabels);
            labels.putAll(this.scopeLabels());
            if (TemplateUtils.executeProcessTemplate(template, this.configuration)) {
                Map<String, String> templateParameters = TemplateUtils.readParameters(template, this.configuration, resolver);
                List<ParamValue> values = this.addParameterValues(templateParameters, this.getType());
                log.info(String.format("Applying OpenShift template: %s", templateURL));
                String templateKeyPrefix = this.templateKeyPrefix();
                try {
                    resources = this.openShiftAdapter.processTemplateAndCreateResources(templateKeyPrefix + templateURL, templateURL, values, labels);
                }
                catch (Exception e) {
                    this.handleExceptionForCreatingResource();
                    throw e;
                }
            } else {
                log.info(String.format("Ignoring template [%s] processing ...", templateURL));
                resources = Collections.emptyList();
            }
            return resources;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot deploy template: " + templateURL, t);
        }
    }

    private void delay(OpenShiftAdapter client, List<? extends OpenShiftResource> resources) throws Exception {
        for (OpenShiftResource openShiftResource : resources) {
            if (!(openShiftResource instanceof DeploymentConfig)) continue;
            DeploymentConfig dc = (DeploymentConfig)openShiftResource;
            client.delay(dc.getSelector(), dc.getReplicas(), Operator.EQUAL);
        }
    }

    private List<ParamValue> addParameterValues(Map<String, String> templateParameters, T type) {
        ArrayList<ParamValue> values = new ArrayList<ParamValue>();
        int replicas = TemplateUtils.readReplicas(type);
        TemplateUtils.addParameterValues(values, templateParameters, false);
        TemplateUtils.addParameterValues(values, System.getenv(), true);
        TemplateUtils.addParameterValues(values, System.getProperties(), true);
        values.add(new ParamValue("REPLICAS", String.valueOf(replicas)));
        return values;
    }
}

