/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.clnt.v4_0.Config;
import io.fabric8.kubernetes.clnt.v4_0.ConfigBuilder;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.openshift.api.ConfigurationHandle;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfigurationBuilder;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;

public class CubeOpenShiftConfiguration
extends DefaultConfiguration
implements ConfigurationHandle,
Serializable {
    private static final Config FALLBACK_CONFIG = new ConfigBuilder().build();
    private static final String ORIGIN_SERVER = "originServer";
    private static final String KEEP_ALIVE_GIT_SERVER = "keepAliveGitServer";
    private static final String DEFINITIONS_FILE = "definitionsFile";
    private static final String DEFINITIONS = "definitions";
    private static final String ENABLE_IMAGE_STREAM_DETECTION = "enableImageStreamDetection";
    private static final String AUTO_START_CONTAINERS = "autoStartContainers";
    private static final String PROXIED_CONTAINER_PORTS = "proxiedContainerPorts";
    private static final String PORT_FORWARDER_BIND_ADDRESS = "portForwardBindAddress";
    private static final String ROUTER_HOST = "routerHost";
    private static final String OPENSHIFT_ROUTER_HTTP_PORT = "openshiftRouterHttpPort";
    private static final String OPENSHIFT_ROUTER_HTTPS_PORT = "openshiftRouterHttpsPort";
    private static final String ROUTER_SNI_PORT = "routerSniPort";
    private static final String TEMPLATE_URL = "templateUrl";
    private static final String TEMPLATE_LABELS = "templateLabels";
    private static final String TEMPLATE_PARAMETERS = "templateParameters";
    private static final String TEMPLATE_PROCESS = "templateProcess";
    private static final String STARTUP_TIMEOUT = "stratupTimeout";
    private static final String HTTP_CLIENT_TIMEOUT = "httpClientTimeout";
    private final boolean keepAliveGitServer;
    private final String definitions;
    private final String definitionsFile;
    private final String[] autoStartContainers;
    private final Set<String> proxiedContainerPorts;
    private final String portForwardBindAddress;
    private final String routerHost;
    private final int openshiftRouterHttpPort;
    private final int openshiftRouterHttpsPort;
    private final boolean enableImageStreamDetection;
    private final int routerSniPort;
    private final String templateURL;
    private final String templateLabels;
    private final String templateParameters;
    private final boolean templateProcess;
    private final long startupTimeout;
    private final long httpClientTimeout;
    private OpenShiftClient client;

    public CubeOpenShiftConfiguration(String sessionId, URL masterUrl, String namespace, Map<String, String> scriptEnvironmentVariables, URL environmentSetupScriptUrl, URL environmentTeardownScriptUrl, URL environmentConfigUrl, List<URL> environmentDependencies, boolean namespaceUseCurrentEnabled, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, boolean namespaceDestroyEnabled, long namespaceDestroyTimeout, boolean namespaceDestroyConfirmationEnabled, boolean waitEnabled, long waitTimeout, long waitPollInterval, List<String> waitForServiceList, boolean ansiLoggerEnabled, boolean environmentInitEnabled, boolean logCopyEnabled, boolean fmpBuildEnabled, boolean fmpBuildForMavenDisable, boolean fmpDebugOutput, boolean fmpLogsEnabled, String fmpPomPath, List<String> fmpProfiles, List<String> fmpSystemProperties, String fmpBuildOptions, String logPath, String kubernetesDomain, String dockerRegistry, boolean keepAliveGitServer, String definitions, String definitionsFile, String[] autoStartContainers, Set<String> proxiedContainerPorts, String portForwardBindAddress, String routerHost, int openshiftRouterHttpPort, int openshiftRouterHttpsPort, boolean enableImageStreamDetection, String token, int routerSniPort, String templateURL, String templateLabels, String templateParameters, boolean templateProcess, String username, String password, String apiVersion, boolean trustCerts, long startupTimeout, long httpClientTimeout) {
        super(sessionId, masterUrl, namespace, scriptEnvironmentVariables, environmentSetupScriptUrl, environmentTeardownScriptUrl, environmentConfigUrl, environmentDependencies, namespaceUseCurrentEnabled, namespaceLazyCreateEnabled, namespaceCleanupEnabled, namespaceCleanupTimeout, namespaceCleanupConfirmationEnabled, namespaceDestroyEnabled, namespaceDestroyConfirmationEnabled, namespaceDestroyTimeout, waitEnabled, waitTimeout, waitPollInterval, waitForServiceList, ansiLoggerEnabled, environmentInitEnabled, logCopyEnabled, logPath, kubernetesDomain, dockerRegistry, token, username, password, apiVersion, trustCerts, fmpBuildEnabled, fmpBuildForMavenDisable, fmpDebugOutput, fmpLogsEnabled, fmpPomPath, fmpProfiles, fmpSystemProperties, fmpBuildOptions);
        this.keepAliveGitServer = keepAliveGitServer;
        this.definitions = definitions;
        this.definitionsFile = definitionsFile;
        this.autoStartContainers = autoStartContainers;
        this.proxiedContainerPorts = proxiedContainerPorts;
        this.portForwardBindAddress = portForwardBindAddress;
        this.routerHost = routerHost;
        this.openshiftRouterHttpPort = openshiftRouterHttpPort;
        this.openshiftRouterHttpsPort = openshiftRouterHttpsPort;
        this.enableImageStreamDetection = enableImageStreamDetection;
        this.routerSniPort = routerSniPort;
        this.templateLabels = templateLabels;
        this.templateParameters = templateParameters;
        this.templateURL = templateURL;
        this.templateProcess = templateProcess;
        this.startupTimeout = startupTimeout;
        this.httpClientTimeout = httpClientTimeout;
    }

    private static String[] split(String str, String regex) {
        if (str == null || str.isEmpty()) {
            return new String[0];
        }
        return str.split(regex);
    }

    public static CubeOpenShiftConfiguration fromMap(Map<String, String> map) {
        String sessionId = UUID.randomUUID().toString().split("-")[0];
        String namespace = ConfigUtil.getBooleanProperty((String)"namespace.use.current", map, (Boolean)false) != false ? new ConfigBuilder().build().getNamespace() : ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
        Boolean shouldDestroyNamespace = false;
        if (Strings.isNullOrEmpty((String)namespace)) {
            namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
            shouldDestroyNamespace = true;
        }
        try {
            return ((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)new CubeOpenShiftConfigurationBuilder().withSessionId(sessionId)).withNamespace(namespace)).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl())))).withScriptEnvironmentVariables(CubeOpenShiftConfiguration.parseMap((String)map.get("env.script.env")))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true))).withLogCopyEnabled(ConfigUtil.getBooleanProperty((String)"logs.copy", map, (Boolean)false))).withLogPath(ConfigUtil.getStringProperty((String)"logs.path", map, null))).withEnvironmentSetupScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.setup.script.url", map, null)))).withEnvironmentTeardownScriptUrl(CubeOpenShiftConfiguration.asUrlOrResource((String)ConfigUtil.getStringProperty((String)"env.teardown.script.url", map, null)))).withEnvironmentConfigUrl(CubeOpenShiftConfiguration.getKubernetesConfigurationUrl(map))).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)"\\s*,\\s*")))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)true))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT))).withNamespaceDestroyEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.enabled", map, (Boolean)shouldDestroyNamespace))).withNamespaceDestroyConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.destroy.confirm.enabled", map, (Boolean)false))).withNamespaceDestroyTimeout(ConfigUtil.getLongProperty((String)"namespace.destroy.timeout", map, (Long)DEFAULT_NAMESPACE_DESTROY_TIMEOUT))).withWaitEnabled(ConfigUtil.getBooleanProperty((String)"wait.enabled", map, (Boolean)true))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)"\\s*,\\s*"))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null))).withDockerRegistry(CubeOpenShiftConfiguration.getDockerRegistry(map))).withKeepAliveGitServer(ConfigUtil.getBooleanProperty((String)KEEP_ALIVE_GIT_SERVER, map, (Boolean)false))).withDefinitions(ConfigUtil.getStringProperty((String)DEFINITIONS, map, null))).withDefinitionsFile(ConfigUtil.getStringProperty((String)DEFINITIONS_FILE, map, null))).withAutoStartContainers(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)AUTO_START_CONTAINERS, map, (String)""), ","))).withProxiedContainerPorts(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)PROXIED_CONTAINER_PORTS, map, (String)""), ","))).withPortForwardBindAddress(ConfigUtil.getStringProperty((String)PORT_FORWARDER_BIND_ADDRESS, map, (String)"127.0.0.1"))).withRouterHost(ConfigUtil.getStringProperty((String)ROUTER_HOST, (String)"openshift.router.host", map, null))).withOpenshiftRouterHttpPort(ConfigUtil.getIntProperty((String)OPENSHIFT_ROUTER_HTTP_PORT, (String)"openshift.router.httpPort", map, (int)80))).withOpenshiftRouterHttpsPort(ConfigUtil.getIntProperty((String)OPENSHIFT_ROUTER_HTTPS_PORT, (String)"openshift.router.httpsPort", map, (int)443))).withEnableImageStreamDetection(ConfigUtil.getBooleanProperty((String)ENABLE_IMAGE_STREAM_DETECTION, map, (Boolean)true))).withToken(ConfigUtil.getStringProperty((String)"cube.auth.token", (String)"kubernetes.auth.token", map, null))).withRouterSniPort(ConfigUtil.getIntProperty((String)ROUTER_SNI_PORT, (String)"openshift.router.sniPort", map, (int)443))).withTemplateURL(ConfigUtil.getStringProperty((String)TEMPLATE_URL, (String)"openshift.template.url", map, null))).withTemplateLabels(ConfigUtil.getStringProperty((String)TEMPLATE_LABELS, (String)"openshift.template.labels", map, null))).withTemplateParameters(ConfigUtil.getStringProperty((String)TEMPLATE_PARAMETERS, (String)"openshift.template.parameters", map, null))).withTemplateProcess(ConfigUtil.getBooleanProperty((String)TEMPLATE_PROCESS, (String)"openshift.template.process", map, (Boolean)true))).withUsername(ConfigUtil.getStringProperty((String)"cube.username", (String)"openshift.username", map, null))).withPassword(ConfigUtil.getStringProperty((String)"cube.password", (String)"openshift.password", map, null))).withApiVersion(ConfigUtil.getStringProperty((String)"cube.api.version", (String)"kubernetes.api.version", map, (String)"v1"))).withTrustCerts(ConfigUtil.getBooleanProperty((String)"cube.trust.certs", (String)"kubernetes.trust.certs", map, (Boolean)true))).withStartupTimeout(ConfigUtil.getLongProperty((String)STARTUP_TIMEOUT, (String)"arquillian.startup.timeout", map, (Long)600L))).withHttpClientTimeout(ConfigUtil.getLongProperty((String)HTTP_CLIENT_TIMEOUT, (String)"arquillian.http.client.timeout", map, (Long)120L))).withFmpBuildEnabled(ConfigUtil.getBooleanProperty((String)"cube.fmp.build", map, (Boolean)false))).withFmpBuildForMavenDisable(ConfigUtil.getBooleanProperty((String)"cube.fmp.build.disable.for.mvn", map, (Boolean)false))).withFmpDebugOutput(ConfigUtil.getBooleanProperty((String)"cube.fmp.debug.output", map, (Boolean)false))).withFmpLogsEnabled(ConfigUtil.getBooleanProperty((String)"cube.fmp.logs", map, (Boolean)true))).withFmpPomPath(ConfigUtil.getStringProperty((String)"cube.fmp.pom.path", map, (String)"pom.xml"))).withFmpProfiles(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"cube.fmp.profiles", map, (String)""), (String)"\\s*,\\s*"))).withFmpSystemProperties(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"cube.fmp.system.properties", map, (String)""), (String)"\\s*,\\s*"))).withFmpBuildOptions(ConfigUtil.getStringProperty((String)"cube.fmp.build.options", map, (String)""))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String getOriginServer() {
        return this.getMasterUrl().toString();
    }

    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public boolean shouldKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String[] getAutoStartContainers() {
        if (this.autoStartContainers == null) {
            return new String[0];
        }
        return this.autoStartContainers;
    }

    public Set<String> getProxiedContainerPorts() {
        if (this.proxiedContainerPorts == null) {
            return Collections.emptySet();
        }
        return this.proxiedContainerPorts;
    }

    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getOpenshiftRouterHttpPort() {
        return this.openshiftRouterHttpPort;
    }

    public int getOpenshiftRouterHttpsPort() {
        return this.openshiftRouterHttpsPort;
    }

    public boolean isEnableImageStreamDetection() {
        return this.enableImageStreamDetection;
    }

    public void setClient(OpenShiftClient client) {
        this.client = client;
    }

    public int getRouterSniPort() {
        return this.routerSniPort;
    }

    public String getToken() {
        if ((super.getToken() == null || super.getToken().isEmpty()) && this.client != null) {
            String token = this.client.getClientExt().getConfiguration().getOauthToken();
            this.setToken(token);
        }
        return super.getToken();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.apply(properties);
        return properties;
    }

    private void apply(Properties properties) {
        properties.put("kubernetes.namespace", this.getNamespace());
        properties.put("namespace", this.getNamespace());
        properties.put("version", this.getApiVersion());
        properties.put("kubernetes.api.version", this.getApiVersion());
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    protected String getTemplateLabels() {
        return this.templateLabels;
    }

    public Map<String, String> getTemplateLabelsAsMap() {
        return org.arquillian.cube.openshift.impl.utils.Strings.splitKeyValueList(this.templateLabels);
    }

    public String getTemplateParameters() {
        return this.templateParameters;
    }

    public Map<String, String> getTemplateParametersAsMap() {
        return org.arquillian.cube.openshift.impl.utils.Strings.splitKeyValueList(this.templateParameters);
    }

    public boolean isTemplateProcess() {
        return this.templateProcess;
    }

    public Configuration getCubeConfiguration() {
        return this;
    }

    public String getKubernetesMaster() {
        return this.getMasterUrl().toString();
    }

    public long getStartupTimeout() {
        return this.startupTimeout;
    }

    public long getHttpClientTimeout() {
        return this.httpClientTimeout;
    }

    public OpenShiftClient getClient() {
        return this.client;
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        StringBuilder content = new StringBuilder();
        content.append(super.toString()).append(lineSeparator);
        content.append("CubeOpenShiftConfiguration: ").append(lineSeparator);
        this.appendPropertyWithValue(content, KEEP_ALIVE_GIT_SERVER, this.keepAliveGitServer);
        if (this.definitions != null) {
            this.appendPropertyWithValue(content, DEFINITIONS, this.definitions);
        }
        if (this.definitionsFile != null) {
            this.appendPropertyWithValue(content, DEFINITIONS_FILE, this.definitionsFile);
        }
        if (this.autoStartContainers != null) {
            this.appendPropertyWithValue(content, AUTO_START_CONTAINERS, Arrays.toString(this.autoStartContainers));
        }
        if (this.proxiedContainerPorts != null) {
            this.appendPropertyWithValue(content, PROXIED_CONTAINER_PORTS, this.proxiedContainerPorts);
        }
        if (this.portForwardBindAddress != null) {
            this.appendPropertyWithValue(content, PORT_FORWARDER_BIND_ADDRESS, this.portForwardBindAddress);
        }
        if (this.routerHost != null) {
            this.appendPropertyWithValue(content, ROUTER_HOST, this.routerHost);
        }
        this.appendPropertyWithValue(content, OPENSHIFT_ROUTER_HTTP_PORT, this.openshiftRouterHttpPort);
        this.appendPropertyWithValue(content, OPENSHIFT_ROUTER_HTTPS_PORT, this.openshiftRouterHttpsPort);
        this.appendPropertyWithValue(content, ENABLE_IMAGE_STREAM_DETECTION, this.enableImageStreamDetection);
        this.appendPropertyWithValue(content, ROUTER_SNI_PORT, this.routerSniPort);
        if (this.templateURL != null) {
            this.appendPropertyWithValue(content, TEMPLATE_URL, this.templateURL);
        }
        if (this.templateLabels != null) {
            this.appendPropertyWithValue(content, TEMPLATE_LABELS, this.templateLabels);
        }
        if (this.templateParameters != null) {
            this.appendPropertyWithValue(content, TEMPLATE_PARAMETERS, this.templateParameters);
        }
        this.appendPropertyWithValue(content, TEMPLATE_PROCESS, this.templateProcess);
        this.appendPropertyWithValue(content, STARTUP_TIMEOUT, this.startupTimeout);
        this.appendPropertyWithValue(content, HTTP_CLIENT_TIMEOUT, this.httpClientTimeout);
        return content.toString();
    }
}

