/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javassist.util.proxy.MethodHandler;
import org.arquillian.cube.openshift.api.ExternalDeployment;
import org.arquillian.cube.openshift.impl.utils.BytecodeUtils;
import org.arquillian.cube.openshift.impl.utils.ReflectionUtils;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class Archives {
    public static final String MGMT_CLIENT_JAR_NAME = "incontainermgmtclient.jar";
    private static final String WEB_XML = "<web-app version=\"3.0\"\n         xmlns=\"http://java.sun.com/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"\n         metadata-complete=\"false\">\n</web-app>";
    private static final String[] defaultDependencies = new String[]{"org.jboss.as.server", "org.jboss.as.controller-client", "org.jboss.jandex", "org.jboss.logging", "org.jboss.modules", "org.jboss.dmr", "org.jboss.msc"};

    public static boolean isMgmtClientJar(Archive<?> archive) {
        return MGMT_CLIENT_JAR_NAME.equals(archive.getName());
    }

    public static boolean isExternalDeployment(Class<?> clazz) {
        return ReflectionUtils.isAnnotationPresent(clazz, ExternalDeployment.class);
    }

    public static WebArchive generateDummyWebArchive() {
        return Archives.generateDummyWebArchive(null);
    }

    public static WebArchive generateDummyWebArchive(String name) {
        WebArchive war = name == null ? (WebArchive)ShrinkWrap.create(WebArchive.class) : (WebArchive)ShrinkWrap.create(WebArchive.class, (String)name);
        war.setWebXML((Asset)new StringAsset(WEB_XML));
        return war;
    }

    public static DeploymentDescription generateDummyDeployment(String name) {
        return new DeploymentDescription("_DEFAULT_", (Archive)Archives.generateDummyWebArchive(name));
    }

    public static Archive<?> toProxy(final Archive<?> archive, final String newArchiveName) {
        Class expected = archive instanceof EnterpriseArchive ? EnterpriseArchive.class : WebArchive.class;
        return (Archive)BytecodeUtils.proxy(expected, new MethodHandler(){

            public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
                if ("getName".equals(method.getName())) {
                    return newArchiveName;
                }
                return method.invoke((Object)archive, args);
            }
        });
    }

    public static void handleDependencies(Archive<?> archive) {
        String value;
        if (!(archive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected: " + archive);
        }
        final Manifest manifest = Archives.getOrCreateManifest(archive);
        ManifestContainer manifestContainer = (ManifestContainer)ManifestContainer.class.cast(archive);
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        StringBuilder moduleDeps = new StringBuilder((value = attributes.getValue("Dependencies")) != null && value.trim().length() > 0 ? value : "");
        moduleDeps.append(defaultDependencies[0]);
        for (int i = 1; i < defaultDependencies.length; ++i) {
            moduleDeps.append(",").append(defaultDependencies[i]);
        }
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        archive.delete(manifestPath);
        manifestContainer.addAsManifestResource(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, "MANIFEST.MF");
    }

    private static Manifest getOrCreateManifest(Archive<?> archive) {
        try {
            Manifest manifest;
            Node node = archive.get("META-INF/MANIFEST.MF");
            if (node == null) {
                manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            } else {
                manifest = new Manifest(node.getAsset().openStream());
            }
            return manifest;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain manifest", ex);
        }
    }
}

