/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.util.logging.Logger;

class ParallelHandle {
    private static final Logger log = Logger.getLogger(ParallelHandle.class.getName());
    private volatile State state = State.INIT;
    private Throwable error;
    private int counter;

    ParallelHandle() {
    }

    Throwable getError() {
        return this.error;
    }

    synchronized void init(String info) {
        log.info(String.format("Build %s init [%s] (%s)", new Object[]{info, this.state, this.counter}));
        if (this.state == State.INIT) {
            this.state = State.IN_PROGRESS;
        }
        this.counter += 2;
    }

    synchronized void clear(String info, String from) {
        log.info(String.format("Clear build %s from %s [%s] (%s)", new Object[]{info, from, this.state, this.counter}));
        if (this.state == State.WAITING) {
            this.notifyAll();
        }
        --this.counter;
        if (this.counter == 0) {
            log.info(String.format("Reset build %s [%s]", new Object[]{info, this.state}));
            this.state = State.INIT;
        }
    }

    synchronized void doNotify(String info) {
        if (this.state == State.WAITING) {
            log.info(String.format("Notifying builds waiting on %s ...", info));
            this.notifyAll();
        } else {
            log.info(String.format("Build %s not waiting [%s].", new Object[]{info, this.state}));
        }
        this.state = State.DONE;
    }

    synchronized void doError(String info, Throwable error) {
        log.warning(String.format("Error in %s build: %s [%s]", new Object[]{info, error, this.state}));
        this.error = error;
        if (this.state == State.WAITING) {
            this.notifyAll();
        }
        this.state = State.ERROR;
    }

    synchronized void doWait(String info) {
        if (this.state == State.IN_PROGRESS) {
            log.info(String.format("Waiting for %s build to finish ...", info));
            this.state = State.WAITING;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        } else {
            log.info(String.format("Build %s not in-progress [%s]", new Object[]{info, this.state}));
        }
    }

    private static enum State {
        INIT,
        DONE,
        IN_PROGRESS,
        WAITING,
        ERROR;

    }
}

