/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.ext;

import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.openshift.impl.utils.Archives;
import org.arquillian.cube.openshift.impl.utils.Containers;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class LegacyDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    private static final String DELEGATE_CLASS = "org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator";

    public List<DeploymentDescription> generate(TestClass testClass) {
        List<DeploymentDescription> descriptions = this.delegate(testClass);
        boolean inCeContainer = Containers.isDeployedInCeContainer();
        ArrayList<DeploymentDescription> copy = new ArrayList<DeploymentDescription>();
        for (DeploymentDescription description : descriptions) {
            Archive archive = description.getArchive();
            if (inCeContainer && JavaArchive.class.isInstance(archive)) {
                JavaArchive jar = (JavaArchive)JavaArchive.class.cast(archive);
                copy.add(new DeploymentDescription(description.getName(), (Archive)this.toWar(jar)));
                continue;
            }
            copy.add(description);
        }
        return copy;
    }

    private WebArchive toWar(JavaArchive jar) {
        WebArchive war = Archives.generateDummyWebArchive();
        this.merge(war, jar);
        return war;
    }

    private void merge(WebArchive war, JavaArchive jar) {
        war.addAsLibraries(new Archive[]{jar});
    }

    private List<DeploymentDescription> delegate(TestClass testClass) {
        try {
            DeploymentScenarioGenerator delegate = (DeploymentScenarioGenerator)Class.forName(DELEGATE_CLASS).newInstance();
            return delegate.generate(testClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

