/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.ext;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.api.ConfigurationHandle;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class RemoteConfigurationResourceProvider
implements ResourceProvider {
    private static final Logger log = Logger.getLogger(RemoteConfigurationResourceProvider.class.getName());
    public static final String FILE_NAME = "ce-arq-configuration.properties";

    private static String check(String value) {
        return value != null ? value : "<NONE_CONFIGURED>";
    }

    public static String toProperties(ConfigurationHandle configuration) {
        try {
            Properties properties = new Properties();
            properties.put("kubernetes.master", RemoteConfigurationResourceProvider.check(configuration.getKubernetesMaster()));
            properties.put("kubernetes.api.version", RemoteConfigurationResourceProvider.check(configuration.getApiVersion()));
            properties.put("kubernetes.namespace", RemoteConfigurationResourceProvider.check(configuration.getNamespace()));
            properties.put("kubernetes.auth.token", RemoteConfigurationResourceProvider.check(configuration.getToken()));
            StringWriter writer = new StringWriter();
            properties.store(writer, "CE Arquillian Configuration");
            log.info(String.format("Stored configuration %s ...", properties));
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean canProvide(Class<?> type) {
        return ConfigurationHandle.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        final Properties properties = new Properties();
        try {
            ClassLoader cl = RemoteConfigurationResourceProvider.class.getClassLoader();
            InputStream stream = cl.getResourceAsStream(FILE_NAME);
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Missing %s file (%s) ...", FILE_NAME, cl));
            }
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new ConfigurationHandle(){

            public String getKubernetesMaster() {
                return properties.getProperty("kubernetes.master");
            }

            public String getApiVersion() {
                return properties.getProperty("kubernetes.api.version");
            }

            public String getNamespace() {
                return properties.getProperty("kubernetes.namespace");
            }

            public String getToken() {
                return properties.getProperty("kubernetes.auth.token");
            }
        };
    }
}

