/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.requirement;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.requirement.Requirements;
import org.arquillian.cube.spi.requirement.Requires;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class ArquillianConditionalRunner
extends Arquillian {
    private static final Logger log = Logger.getLogger(ArquillianConditionalRunner.class.getName());

    public ArquillianConditionalRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    public void run(RunNotifier notifier) {
        Class testClass = this.getTestClass().getJavaClass();
        try {
            this.checkRequirements(testClass);
            super.run(notifier);
        }
        catch (UnsatisfiedRequirementException e) {
            log.log(Level.WARNING, String.format("Unsatisfied assumption in test class %s. Requirement problem: %s.", testClass.getName(), e.getMessage()));
            notifier.fireTestAssumptionFailed(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    private void checkRequirements(Class<?> testClass) throws UnsatisfiedRequirementException {
        Requirements.checkRequirement(testClass.getAnnotation(Requires.class), null);
        for (Annotation annotation : testClass.getAnnotations()) {
            Requirements.checkRequirement(annotation.annotationType().getAnnotation(Requires.class), annotation);
        }
    }
}

