/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.assertions;

import com.github.dockerjava.CubeOutput;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.assertions.ContainerAssert;
import com.github.dockerjava.assertions.ContainersAssert;
import com.github.dockerjava.assertions.CubeOutputAssert;
import com.github.dockerjava.assertions.ImagesAssert;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DockerJavaAssert {
    private DockerClient client;

    public DockerJavaAssert(DockerClient client) {
        this.client = client;
    }

    public ImagesAssert hasImages(String ... images) {
        List imageList = (List)this.client.listImagesCmd().exec();
        ImagesAssert imagesAssert = new ImagesAssert(imageList);
        imagesAssert.containsImages(images);
        return imagesAssert;
    }

    public ContainerAssert container(String name) {
        InspectContainerResponse container = this.getContainerInformation(name);
        return new ContainerAssert(container);
    }

    public CubeOutputAssert withContainer(String name) {
        String[] cmd = new String[]{"sh", "-c", "for i in $(ps -axo pid --no-headers); do echo `ps -p $i -o comm=`; done"};
        return new CubeOutputAssert(this.getOutputOfCommand(name, cmd));
    }

    public ContainersAssert containers(String ... names) {
        ArrayList<InspectContainerResponse> containers = new ArrayList<InspectContainerResponse>();
        for (String containerName : names) {
            InspectContainerResponse container = this.getContainerInformation(containerName);
            if (container == null) continue;
            containers.add(container);
        }
        return new ContainersAssert(containers);
    }

    private InspectContainerResponse getContainerInformation(String name) {
        return this.client.inspectContainerCmd(name).exec();
    }

    private CubeOutput getOutputOfCommand(String containerId, String[] command) {
        String execResponseId = this.execCreate(containerId, command);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            ((ExecStartResultCallback)this.client.execStartCmd(execResponseId).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)outputStream, (OutputStream)errorStream))).awaitCompletion();
        }
        catch (InterruptedException e) {
            return new CubeOutput("", "");
        }
        return new CubeOutput(outputStream.toString().trim(), ((Object)errorStream).toString().trim());
    }

    private String execCreate(String containerId, String ... command) {
        return ((ExecCreateCmdResponse)this.client.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(command).exec()).getId();
    }
}

