/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.assertions;

import com.github.dockerjava.CubeOutput;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.SoftAssertionListAssert;
import org.assertj.core.api.SoftAssertions;

public class CubeOutputAssert
extends AbstractAssert<CubeOutputAssert, CubeOutput> {
    public CubeOutputAssert(CubeOutput actual) {
        super((Object)actual, CubeOutputAssert.class);
    }

    public CubeOutputAssert hasProcessRunning(String processName) {
        this.isNotNull();
        List<String> processes = this.getProcesses(((CubeOutput)this.actual).getOutput());
        SoftAssertions softAssertions = new SoftAssertions();
        softAssertions.assertThat(((CubeOutput)this.actual).getError()).isEmpty();
        ((SoftAssertionListAssert)softAssertions.assertThat(processes).overridingErrorMessage("Expected container's running process to contain <%s> but was %n <%s>", new Object[]{processName, processes})).contains((Object[])new String[]{processName});
        softAssertions.assertAll();
        return this;
    }

    public CubeOutputAssert hasProcessesRunning(String ... processes) {
        this.isNotNull();
        List<String> actualProcesses = this.getProcesses(((CubeOutput)this.actual).getOutput());
        SoftAssertions softAssertions = new SoftAssertions();
        softAssertions.assertThat(((CubeOutput)this.actual).getError()).isEmpty();
        ((SoftAssertionListAssert)softAssertions.assertThat(actualProcesses).overridingErrorMessage("Expected container's running processes to contain %n <%s> but was %n <%s>", new Object[]{Arrays.asList(processes), actualProcesses})).contains((Object[])processes);
        softAssertions.assertAll();
        return this;
    }

    private List<String> getProcesses(String processes) {
        return Arrays.asList(processes.split("\n"));
    }
}

