/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.spi;

import java.io.File;
import org.arquillian.droidium.native_.spi.AndroidDeployment;
import org.arquillian.droidium.native_.spi.DroidiumDeployment;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.arquillian.droidium.native_.spi.Validate;
import org.jboss.shrinkwrap.api.Archive;

public class SelendroidDeployment
extends DroidiumDeployment {
    private File workingCopy;
    private File rebuilt;
    private File resigned;
    private String serverBasePackage;
    private AndroidDeployment instrumentedDeployment;
    private InstrumentationConfiguration configuration;
    private String androidDeploymentName;
    private String selendroidPackageName;

    public SelendroidDeployment setWorkingCopy(File selendroidWorkingCopy) {
        Validate.notNull(selendroidWorkingCopy, "Selendroid working copy to set can not be a null object!");
        this.workingCopy = selendroidWorkingCopy;
        return this;
    }

    public File getWorkingCopy() {
        return this.workingCopy;
    }

    public SelendroidDeployment setRebuilt(File rebuiltSelendroid) {
        Validate.notNull(rebuiltSelendroid, "Rebuilt Selendroid server to set can not be a null object!");
        this.rebuilt = rebuiltSelendroid;
        return this;
    }

    public File getRebuilt() {
        return this.rebuilt;
    }

    public SelendroidDeployment setResigned(File resignedSelendroid) {
        Validate.notNull(resignedSelendroid, "Resigned Selendroid server to set can not be a null object!");
        this.resigned = resignedSelendroid;
        return this;
    }

    public File getResigned() {
        return this.resigned;
    }

    public SelendroidDeployment setServerBasePackage(String serverBasePackage) {
        Validate.notNullOrEmpty(serverBasePackage, "Selendroid server base package to set can not be a null object nor an empty string!");
        this.serverBasePackage = serverBasePackage;
        return this;
    }

    public String getServerBasePackage() {
        return this.serverBasePackage;
    }

    @Override
    public Archive<?> getDeployment() {
        if (this.getInstrumentedDeployment() == null) {
            throw new IllegalStateException("You have not set what deployment you want to instrument yet. Please call setInstrumentedDeployment(AndroidDeployment) firstly.");
        }
        return this.getInstrumentedDeployment().getDeployment();
    }

    public SelendroidDeployment setInstrumentedDeployment(AndroidDeployment instrumentedDeployment) {
        Validate.notNull(instrumentedDeployment, "Android deployment can not be a null object!");
        this.instrumentedDeployment = instrumentedDeployment;
        return this;
    }

    public AndroidDeployment getInstrumentedDeployment() {
        return this.instrumentedDeployment;
    }

    public SelendroidDeployment setInstrumentationConfiguration(InstrumentationConfiguration configuration) {
        Validate.notNull(configuration, "Instrumentation configuration for Selendroid deployment can not be a null object!");
        this.configuration = configuration;
        return this;
    }

    public InstrumentationConfiguration getInstrumentationConfiguration() {
        return this.configuration;
    }

    @Override
    public String getDeploymentName() {
        return this.androidDeploymentName;
    }

    public SelendroidDeployment setDeploymentName(String androidDeploymentName) {
        Validate.notNullOrEmpty(androidDeploymentName, "Android deployment name for Selendroid server deployment can not be a null object nor an empty string!");
        this.androidDeploymentName = androidDeploymentName;
        return this;
    }

    public SelendroidDeployment setSelendroidPackageName(String selendroidPackageName) {
        Validate.notNullOrEmpty(selendroidPackageName, "Selendroid package name to set can not be a null object not an empty string!");
        this.selendroidPackageName = selendroidPackageName;
        return this;
    }

    public String getSelendroidPackageName() {
        return this.selendroidPackageName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selendroidPackageName == null ? 0 : this.selendroidPackageName.hashCode());
        result = 31 * result + (this.serverBasePackage == null ? 0 : this.serverBasePackage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelendroidDeployment other = (SelendroidDeployment)obj;
        if (this.selendroidPackageName == null ? other.selendroidPackageName != null : !this.selendroidPackageName.equals(other.selendroidPackageName)) {
            return false;
        }
        return !(this.serverBasePackage == null ? other.serverBasePackage != null : !this.serverBasePackage.equals(other.serverBasePackage));
    }
}

