/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.spi;

import org.arquillian.droidium.native_.spi.exception.InvalidInstrumentationConfigurationException;

public class InstrumentationConfiguration {
    private String port;

    public void setPort(int port) throws InvalidInstrumentationConfigurationException {
        this.setPort(Integer.toString(port));
    }

    public void setPort(String port) throws InvalidInstrumentationConfigurationException {
        try {
            int portToValidate = Integer.parseInt(port);
            if (!InstrumentationConfiguration.isValidPortNumber(portToValidate)) {
                throw new InvalidInstrumentationConfigurationException("Unable to parse instrumentation port, you entered: " + portToValidate);
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidInstrumentationConfigurationException(ex);
        }
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public void validate() {
        if (this.port == null) {
            throw new InvalidInstrumentationConfigurationException("Port not set!");
        }
    }

    public static boolean isValidPortNumber(int port) {
        return port >= 1024 && port <= 65535;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstrumentationConfiguration other = (InstrumentationConfiguration)obj;
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }
}

