/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.platform.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.arquillian.droidium.platform.impl.Validate;

public class DroidiumPlatformConfiguration {
    private static final Logger logger = Logger.getLogger(DroidiumPlatformConfiguration.class.getName());
    private String fileSeparator = System.getProperty("file.separator");
    private Map<String, String> properties = new HashMap<String, String>();
    private String forceNewBridge = "false";
    private String androidHome = this.resolveAndroidHome();
    private String androidSdkHome = this.resolveAndroidSdkHome();
    private String javaHome = this.resolveJavaHome();
    private String ddmlibCommandTimeout = "20000";
    private String storepass = "android";
    private String keypass = "android";
    private String alias = "androiddebugkey";
    private String sigalg = "SHA1withRSA";
    private String keyalg = "RSA";
    private String removeTmpDir = "true";
    private String adbServerPort = "5037";
    private String keystore = null;
    private String tmpDir = this.resolveTmpDir();

    public boolean isForceNewBridge() {
        return Boolean.parseBoolean(this.getProperty("forceNewBridge", this.forceNewBridge));
    }

    public String getAndroidHome() {
        return this.getProperty("androidHome", this.androidHome);
    }

    public String getAndroidSdkHome() {
        return this.getProperty("androidSdkHome", this.androidSdkHome);
    }

    public String getJavaHome() {
        return this.getProperty("javaHome", this.javaHome);
    }

    public String getDdmlibCommandTimeout() {
        return this.getProperty("ddmlibCommandTimeout", this.ddmlibCommandTimeout);
    }

    public String getStorepass() {
        return this.getProperty("storepass", this.storepass);
    }

    public String getKeypass() {
        return this.getProperty("keypass", this.keypass);
    }

    public String getAlias() {
        return this.getProperty("alias", this.alias);
    }

    public String getSigalg() {
        return this.getProperty("sigalg", this.sigalg);
    }

    public String getKeyalg() {
        return this.getProperty("keyalg", this.keyalg);
    }

    public boolean isRemoveTmpDir() {
        return Boolean.parseBoolean(this.getProperty("removeTmpDir", this.removeTmpDir));
    }

    public String getAdbServerPort() {
        return this.getProperty("adbServerPort", this.adbServerPort);
    }

    public String getKeystore() {
        return this.getProperty("keystore", this.keystore);
    }

    public File getTmpDir() {
        return new File(this.getProperty("tmpDir", this.tmpDir));
    }

    public Boolean getRemoveTmpDir() {
        return Boolean.parseBoolean(this.getProperty("removeTmpDir", this.removeTmpDir));
    }

    public Boolean getForceNewBridge() {
        return Boolean.parseBoolean(this.getProperty("forceNewBridge", this.forceNewBridge));
    }

    public String resolveJavaHome() {
        String JAVA_HOME_ENV = System.getenv("JAVA_HOME");
        String JAVA_HOME_PROPERTY = System.getProperty("java.home");
        return this.checkSlash(JAVA_HOME_PROPERTY == null ? JAVA_HOME_ENV : JAVA_HOME_PROPERTY);
    }

    public String resolveAndroidHome() {
        String ANDROID_HOME_ENV = System.getenv("ANDROID_HOME");
        String ANDROID_HOME_PROPERTY = System.getProperty("android.home");
        return this.checkSlash(ANDROID_HOME_PROPERTY == null ? ANDROID_HOME_ENV : ANDROID_HOME_PROPERTY);
    }

    public String resolveAndroidSdkHome() {
        String ANDROID_SDK_HOME_ENV = System.getenv("ANDROID_SDK_HOME");
        String ANDROID_SDK_HOME_PROPERTY = System.getProperty("android.sdk.home");
        return this.checkSlash(ANDROID_SDK_HOME_PROPERTY == null ? (ANDROID_SDK_HOME_ENV == null ? this.resolveUserHome() : ANDROID_SDK_HOME_ENV) : ANDROID_SDK_HOME_PROPERTY);
    }

    public String resolveUserHome() {
        String USER_HOME_ENV = System.getenv("HOME");
        String USER_HOME_PROPERTY = System.getProperty("user.home");
        return this.checkSlash(USER_HOME_PROPERTY == null ? USER_HOME_ENV : USER_HOME_PROPERTY);
    }

    public String resolveTmpDir() {
        String TMP_DIR_PROPERTY;
        String TMP_DIR_ENV = System.getenv("TMPDIR");
        if (TMP_DIR_ENV == null) {
            TMP_DIR_ENV = System.getenv("TEMP");
        }
        if (TMP_DIR_ENV == null) {
            TMP_DIR_ENV = System.getenv("TMP");
        }
        if (TMP_DIR_ENV != null) {
            TMP_DIR_ENV = TMP_DIR_ENV.trim();
        }
        if ((TMP_DIR_PROPERTY = System.getProperty("droidium.tmpdir")) != null) {
            TMP_DIR_PROPERTY = TMP_DIR_PROPERTY.trim();
        }
        if (TMP_DIR_ENV == null && TMP_DIR_PROPERTY == null) {
            return this.checkSlash(System.getProperty("java.io.tmpdir"));
        }
        return this.checkSlash(TMP_DIR_PROPERTY == null ? TMP_DIR_ENV : TMP_DIR_PROPERTY);
    }

    public void setProperties(Map<String, String> properties) {
        Validate.notNull(properties, "Properties to set for Arquillian Droidium Platform configuration can not be a null object!");
        this.properties = properties;
    }

    public String getProperty(String name, String defaultValue) throws IllegalStateException {
        Validate.notNullOrEmpty(name, "unable to get configuration value of null configuration key");
        String found = this.properties.get(name);
        if (found == null || found.length() == 0) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String property, String value) throws IllegalStateException {
        Validate.notNullOrEmpty(property, "unable to set configuration value which key is null");
        Validate.notNullOrEmpty(value, "unable to set configuration value which is null");
        this.properties.put(property, value);
    }

    public void validate() {
        if (this.getAndroidHome() == null) {
            throw new IllegalStateException("You have not set ANDROID_HOME environment property nor android.home system property. System property gets precedence.");
        }
        this.setProperty("androidHome", this.checkSlash(this.getAndroidHome()));
        if (this.getJavaHome() == null) {
            throw new IllegalStateException("You have not set JAVA_HOME environment property nor java.home system property. System property gets precedence.");
        }
        this.setProperty("javaHome", this.checkSlash(this.getJavaHome()));
        this.setProperty("androidSdkHome", this.checkSlash(this.getAndroidSdkHome()));
        Validate.isReadableDirectory(this.getAndroidSdkHome(), "You must provide Android SDK home directory. The value you have provided is not valid. You can either set it via an environment variable ANDROID_SDK_HOME or via property called \"androidSdkHome\" in Arquillian configuration or you can set it as system property \"android.sdk.home\". When this property is not specified anywhere, it defaults to \"" + this.resolveUserHome() + "\"");
        Validate.isReadableDirectory(this.getAndroidHome(), "You must provide Android home directory. The value you have provided is not valid. You can either set it via environment variable ANDROID_HOME or via property called \"androidHome\" in Arquillian configuration or you can set it as system property \"android.home\".");
        if (this.adbServerPort != null) {
            Validate.isPortValid(this.adbServerPort);
        }
        File tmpDir = new File(this.getTmpDir(), UUID.randomUUID().toString());
        this.setProperty("tmpDir", tmpDir.getAbsolutePath());
        if (!tmpDir.exists()) {
            this.createTmpDir(tmpDir);
        }
        if (this.keystore == null) {
            this.keystore = this.getAndroidSdkHome() + ".android" + this.fileSeparator + "debug.keystore";
            this.setProperty("keystore", this.keystore);
        }
        try {
            Validate.isReadable(this.getKeystore(), "Key store for Android APKs is not readable. File does not exist or you have no read access to this file. In case it does not exist, Arquillian Droidium native plugin tries to create keystore you specified dynamically in the file " + this.getKeystore());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Validate.notNullOrEmpty(this.getAlias(), "You must provide valid alias for signing of APK files. You entered '" + this.getAlias() + "'.");
        Validate.notNullOrEmpty(this.getKeypass(), "You must provide valid keypass for signing of APK files. You entered '" + this.getKeypass() + "'.");
        Validate.notNullOrEmpty(this.getStorepass(), "You must provide valid storepass for signing of APK files. You entered '" + this.getStorepass() + "'.");
        Validate.notNullOrEmpty(this.getKeyalg(), "You must provide valid key algorithm for signing packages. You entered '" + this.getKeyalg() + "'.");
        Validate.notNullOrEmpty(this.getSigalg(), "You must provide valid key algoritm for signing packages. You entered '" + this.getSigalg() + "'.");
    }

    public Map<String, String> getAndroidSystemEnvironmentProperties() {
        HashMap<String, String> androidEnvironmentProperties = new HashMap<String, String>();
        androidEnvironmentProperties.put("ANDROID_HOME", this.getAndroidHome());
        androidEnvironmentProperties.put("ANDROID_SDK_HOME", this.getAndroidSdkHome());
        androidEnvironmentProperties.put("ANDROID_ADB_SERVER_PORT", this.getAdbServerPort());
        return androidEnvironmentProperties;
    }

    private String checkSlash(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return path.endsWith(this.fileSeparator) ? path : path + this.fileSeparator;
    }

    private void createTmpDir(File parent) {
        try {
            boolean created = parent.mkdirs();
            if (!created) {
                throw new RuntimeException("Unable to create temporary directory " + parent.getAbsolutePath());
            }
        }
        catch (SecurityException ex) {
            logger.severe("Security manager denies to create the working dir in " + parent.getAbsolutePath());
            throw new RuntimeException("Unable to create working directory in " + parent.getAbsolutePath());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "HOME", this.resolveUserHome()));
        sb.append(String.format("%-40s %s\n", "JAVA_HOME", this.getJavaHome()));
        sb.append(String.format("%-40s %s\n", "ANDROID_HOME", this.getAndroidHome()));
        sb.append(String.format("%-40s %s\n", "ANDROID_SDK_HOME", this.getAndroidSdkHome()));
        sb.append(String.format("%-40s %s\n", "adbServerPort", this.getAdbServerPort()));
        sb.append(String.format("%-40s %s\n", "keystore", this.getKeystore()));
        sb.append(String.format("%-40s %s\n", "keypass", this.getKeypass()));
        sb.append(String.format("%-40s %s\n", "storepass", this.getStorepass()));
        sb.append(String.format("%-40s %s\n", "alias", this.getAlias()));
        sb.append(String.format("%-40s %s\n", "sigalg", this.getSigalg()));
        sb.append(String.format("%-40s %s\n", "keyalg", this.getKeyalg()));
        sb.append(String.format("%-40s %s\n", "tmpDir", this.getTmpDir()));
        sb.append(String.format("%-40s %s\n", "removeTmpDir", this.getRemoveTmpDir()));
        sb.append(String.format("%-40s %s\n", "ddmlibCommandTimeout", this.getDdmlibCommandTimeout()));
        sb.append(String.format("%-40s %s", "forceNewBridge", this.getForceNewBridge()));
        return sb.toString();
    }
}

