/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.platform.impl;

import java.io.File;

class Validate {
    Validate() {
    }

    public static void notNull(Object object, String message) throws IllegalStateException, IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Exception message is a null object!");
        }
        if (object == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNulls(Object[] objects, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        Validate.notNull(objects, "Array to check the nullity of objects is a null object.");
        for (Object o : objects) {
            if (o != null) continue;
            throw new IllegalStateException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        if (string == null || string.trim().length() == 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void notAllNullsOrEmpty(String[] strings, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        Validate.notNull(strings, "Array to check the nullity of objects is null object!");
        if (strings.length == 0) {
            return;
        }
        for (String string : strings) {
            if (string == null || string.trim().length() == 0) continue;
            return;
        }
        throw new IllegalStateException(message);
    }

    public static boolean isReadable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "File to check against readability is null object or empty.");
        File file = new File(path);
        return Validate.isReadable(file, message);
    }

    public static void isReadableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, message);
        File file = new File(path);
        Validate.isReadableDirectory(file, message);
    }

    public static boolean isReadable(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, message);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static void isReadableDirectory(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, "Directory to check against readability is null object.");
        if (!(file.exists() && file.isDirectory() && file.canRead() && file.canExecute())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isPortValid(int port) {
        return port > 0 && port < 65535;
    }

    public static boolean isPortValid(String port) {
        return Validate.isPortValid(Integer.parseInt(port));
    }

    public static void isWritable(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, "File to check against writability is a null object.");
        Validate.notNullOrEmpty(message, "exception message can not be null or empty string");
        if (!file.exists() || !file.canWrite()) {
            throw new IllegalArgumentException(message);
        }
    }
}

