/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.github.configuration;

import org.arquillian.extension.governor.api.Configuration;
import org.arquillian.extension.governor.api.GovernorConfigurationException;

public class GitHubGovernorConfiguration
extends Configuration {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_GITHUB_CLOSING_MESSAGE = "This GitHub issue was automatically closed by %s with Arquillian Governor GitHub extension.";
    private String username = this.resolveUsername();
    private String password = this.resolvePassword();
    private String token = this.resolveToken();
    private String repositoryUser = this.resolveRepositoryUser();
    private String repository = this.resolveRepository();
    private boolean force = this.resolveForce();
    private boolean closePassed = this.resolveClosePassed();

    public void setUsername(String username) {
        this.setProperty("username", username);
    }

    public String getUsername() {
        return this.getProperty("username", this.username);
    }

    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    public String getPassword() {
        return this.getProperty("password", this.password);
    }

    public void setToken(String token) {
        this.setProperty("token", token);
    }

    public String getToken() {
        return this.getProperty("token", this.token);
    }

    public void setRepositoryUser(String repositoryUser) {
        this.setProperty("repositoryUser", repositoryUser);
    }

    public String getRepositoryUser() {
        return this.getProperty("repositoryUser", this.repositoryUser);
    }

    public void setRepository(String repository) {
        this.setProperty("repository", repository);
    }

    public String getRepository() {
        return this.getProperty("repository", this.repository);
    }

    public void setForce(boolean force) {
        this.setProperty("force", Boolean.toString(force));
    }

    public boolean getForce() {
        return Boolean.parseBoolean(this.getProperty("force", Boolean.toString(this.force)));
    }

    public void setClosePassed(boolean closePassed) {
        this.setProperty("closePassed", Boolean.toString(closePassed));
    }

    public boolean getClosePassed() {
        return Boolean.parseBoolean(this.getProperty("closePassed", Boolean.toString(this.closePassed)));
    }

    public void setClosingMessage(String closingMessage) {
        this.setProperty("closingMessage", closingMessage);
    }

    public String getClosingMessage() {
        return this.getProperty("closingMessage", DEFAULT_GITHUB_CLOSING_MESSAGE);
    }

    public void validate() throws GovernorConfigurationException {
        if (EMPTY_STRING.equals(this.getRepositoryUser()) || EMPTY_STRING.equals(this.getRepository())) {
            throw new GovernorConfigurationException("Repository user or repository name are not set - it is an empty String.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "username", this.getUsername()));
        sb.append(String.format("%-40s %s\n", "repositoryUser", this.getRepositoryUser()));
        sb.append(String.format("%-40s %s\n", "repository", this.getRepository()));
        sb.append(String.format("%-40s %s\n", "force", this.getForce()));
        sb.append(String.format("%-40s %s\n", "closePassed", this.getClosePassed()));
        sb.append(String.format("%-40s %s\n", "closingMessage", this.getClosingMessage()));
        return sb.toString();
    }

    private String resolvePassword() {
        String password = System.getProperty("github.governor.password");
        if (password != null && password.length() != 0) {
            return password;
        }
        return EMPTY_STRING;
    }

    private String resolveUsername() {
        String username = System.getProperty("github.governor.username");
        if (username != null && username.length() != 0) {
            return username;
        }
        return EMPTY_STRING;
    }

    private String resolveToken() {
        String token = System.getProperty("github.governor.token");
        if (token != null && token.length() != 0) {
            return token;
        }
        return EMPTY_STRING;
    }

    private String resolveRepositoryUser() {
        String repositoryUser = System.getProperty("github.governor.repositoryuser");
        if (repositoryUser != null && repositoryUser.length() != 0) {
            return repositoryUser;
        }
        return EMPTY_STRING;
    }

    private String resolveRepository() {
        String repository = System.getProperty("github.governor.repository");
        if (repository != null && repository.length() != 0) {
            return repository;
        }
        return EMPTY_STRING;
    }

    private boolean resolveForce() {
        return Boolean.valueOf(System.getProperty("github.governor.force"));
    }

    private boolean resolveClosePassed() {
        return Boolean.valueOf(System.getProperty("github.governor.closepassed"));
    }
}

