/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.github.impl;

import java.io.IOException;
import java.util.logging.Logger;
import org.arquillian.extension.governor.api.GovernorClient;
import org.arquillian.extension.governor.github.api.GitHub;
import org.arquillian.extension.governor.github.configuration.GitHubGovernorConfiguration;
import org.arquillian.extension.governor.github.impl.GitHubGovernorStrategy;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;

public class GitHubGovernorClient
implements GovernorClient<GitHub, GitHubGovernorStrategy> {
    private static final Logger logger = Logger.getLogger(GitHubGovernorClient.class.getName());
    private GitHubClient gitHubClient;
    private GitHubGovernorConfiguration gitHubGovernorConfiguration;
    private IssueService issueService;
    private GitHubGovernorStrategy gitHubGovernorStrategy;

    public GitHubGovernorClient(GitHubClient gitHubClient, GitHubGovernorConfiguration gitHubGovernorConfiguration) {
        this.initializeGitHubClient(gitHubClient);
        this.setConfiguration(gitHubGovernorConfiguration);
    }

    public ExecutionDecision resolve(GitHub annotation) {
        Validate.notNull((Object)this.gitHubClient, (String)"GitHub REST client must be specified.");
        Validate.notNull((Object)this.gitHubGovernorStrategy, (String)"Governor strategy must be specified. Have you already called setGovernorStrategy()?");
        String gitHubIssueKey = annotation.value();
        if (gitHubIssueKey == null || gitHubIssueKey.length() == 0) {
            return ExecutionDecision.execute();
        }
        Issue gitHubIssue = this.getIssue(gitHubIssueKey);
        if (gitHubIssue == null) {
            logger.warning(String.format("GitHub Issue %s couldn't be retrieved from configured repository.", gitHubIssueKey));
            return ExecutionDecision.execute();
        }
        return this.gitHubGovernorStrategy.annotation(annotation).issue(gitHubIssue).resolve();
    }

    public void close(String issueId) {
        Validate.notNull((Object)this.gitHubClient, (String)"GitHub REST client must be specified.");
        Comment comment = null;
        try {
            Issue issue = this.getIssue(issueId);
            issue.setState("closed");
            comment = this.issueService.createComment(this.gitHubGovernorConfiguration.getRepositoryUser(), this.gitHubGovernorConfiguration.getRepository(), issueId, this.getClosingMessage());
            this.issueService.editIssue(this.gitHubGovernorConfiguration.getRepositoryUser(), this.gitHubGovernorConfiguration.getRepository(), issue);
        }
        catch (Exception e) {
            if (comment != null) {
                this.deleteComment(comment);
            }
            logger.warning(String.format("An exception has occured while closing the issue %s. Exception: %s", issueId, e.getMessage()));
        }
    }

    private void deleteComment(Comment comment) {
        try {
            this.issueService.deleteComment(this.gitHubGovernorConfiguration.getRepositoryUser(), this.gitHubGovernorConfiguration.getRepository(), comment.getId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setGovernorStrategy(GitHubGovernorStrategy strategy) {
        Validate.notNull((Object)strategy, (String)"GitHub Governor strategy must be specified.");
        this.gitHubGovernorStrategy = strategy;
    }

    public GitHubClient getGitHubClient() {
        return this.gitHubClient;
    }

    private void setConfiguration(GitHubGovernorConfiguration gitHubGovernorConfiguration) {
        Validate.notNull((Object)((Object)gitHubGovernorConfiguration), (String)"GitHub Governor configuration must be specified.");
        this.gitHubGovernorConfiguration = gitHubGovernorConfiguration;
    }

    private void initializeGitHubClient(GitHubClient gitHubClient) {
        Validate.notNull((Object)gitHubClient, (String)"GitHub client must be specified.");
        this.gitHubClient = gitHubClient;
        this.issueService = new IssueService(this.gitHubClient);
    }

    private Issue getIssue(String issueNumber) {
        try {
            return this.issueService.getIssue(this.gitHubGovernorConfiguration.getRepositoryUser(), this.gitHubGovernorConfiguration.getRepository(), issueNumber);
        }
        catch (Exception e) {
            logger.warning(String.format("An exception has occured while getting the issue %s. Exception: %s", issueNumber, e.getMessage()));
            return null;
        }
    }

    private String getClosingMessage() {
        Validate.notNull((Object)((Object)this.gitHubGovernorConfiguration), (String)"GitHub Governor configuration must be set.");
        String username = this.gitHubGovernorConfiguration.getUsername();
        if (username == null || username.isEmpty()) {
            username = "unknown";
        }
        return String.format(this.gitHubGovernorConfiguration.getClosingMessage(), username);
    }
}

