/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.github.impl;

import org.arquillian.extension.governor.api.GovernorClientFactory;
import org.arquillian.extension.governor.github.configuration.GitHubGovernorConfiguration;
import org.arquillian.extension.governor.github.impl.GitHubGovernorClient;
import org.arquillian.extension.governor.github.impl.GitHubGovernorStrategy;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.jboss.arquillian.core.spi.Validate;

public class GitHubGovernorClientFactory
implements GovernorClientFactory<GitHubGovernorConfiguration, GitHubGovernorClient> {
    private GitHubGovernorConfiguration gitHubGovernorConfiguration;

    public GitHubGovernorClient build(GitHubGovernorConfiguration governorConfiguration) throws Exception {
        Validate.notNull((Object)((Object)governorConfiguration), (String)"GitHub governor configuration has to be set.");
        this.gitHubGovernorConfiguration = governorConfiguration;
        GitHubClient gitHubClient = new GitHubClient();
        if (this.gitHubGovernorConfiguration.getUsername() != null && this.gitHubGovernorConfiguration.getUsername().length() > 0 && this.gitHubGovernorConfiguration.getPassword() != null && this.gitHubGovernorConfiguration.getPassword().length() > 0) {
            gitHubClient.setCredentials(this.gitHubGovernorConfiguration.getUsername(), this.gitHubGovernorConfiguration.getPassword());
        }
        if (this.gitHubGovernorConfiguration.getToken() != null && this.gitHubGovernorConfiguration.getToken().length() > 0) {
            gitHubClient.setOAuth2Token(this.gitHubGovernorConfiguration.getToken());
        }
        GitHubGovernorClient gitHubGovernorClient = new GitHubGovernorClient(gitHubClient, this.gitHubGovernorConfiguration);
        gitHubGovernorClient.setGovernorStrategy(new GitHubGovernorStrategy(this.gitHubGovernorConfiguration));
        return gitHubGovernorClient;
    }
}

