/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.github.impl;

import org.arquillian.extension.governor.api.GovernorStrategy;
import org.arquillian.extension.governor.github.api.GitHub;
import org.arquillian.extension.governor.github.configuration.GitHubGovernorConfiguration;
import org.eclipse.egit.github.core.Issue;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;

public class GitHubGovernorStrategy
implements GovernorStrategy {
    public static final String FORCING_EXECUTION_REASON_STRING = "forcing execution";
    public static final String SKIPPING_EXECUTION_REASON_STRING = "Skipping %s. Status %s.";
    public static final Object GITHUB_CLOSED_STRING = "closed";
    private GitHubGovernorConfiguration gitHubGovernorConfiguration;
    private GitHub annotation;
    private Issue gitHubIssue;

    public GitHubGovernorStrategy(GitHubGovernorConfiguration gitHubGovernorConfiguration) {
        Validate.notNull((Object)((Object)gitHubGovernorConfiguration), (String)"GitHub Governor configuration has to be set.");
        this.gitHubGovernorConfiguration = gitHubGovernorConfiguration;
    }

    public GitHubGovernorStrategy annotation(GitHub annotation) {
        this.annotation = annotation;
        return this;
    }

    public GitHubGovernorStrategy issue(Issue gitHubIssue) {
        this.gitHubIssue = gitHubIssue;
        return this;
    }

    public ExecutionDecision resolve() {
        Validate.notNull((Object)this.gitHubIssue, (String)"GitHub issue must be specified.");
        Validate.notNull((Object)this.annotation, (String)"Annotation must be specified.");
        String gitHubStatus = this.gitHubIssue.getState();
        if (gitHubStatus == null || gitHubStatus.length() == 0) {
            return ExecutionDecision.execute();
        }
        if (this.annotation.force()) {
            return ExecutionDecision.execute((String)FORCING_EXECUTION_REASON_STRING);
        }
        if (this.gitHubGovernorConfiguration.getForce()) {
            return ExecutionDecision.execute((String)FORCING_EXECUTION_REASON_STRING);
        }
        if (gitHubStatus.equals(GITHUB_CLOSED_STRING)) {
            return ExecutionDecision.execute();
        }
        return ExecutionDecision.dontExecute((String)String.format(SKIPPING_EXECUTION_REASON_STRING, this.gitHubIssue.getNumber(), gitHubStatus));
    }
}

