/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.github.configuration;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.extension.governor.github.configuration.GitHubGovernorConfiguration;
import org.arquillian.extension.governor.github.impl.GitHubGovernorClient;
import org.arquillian.extension.governor.github.impl.GitHubGovernorClientFactory;
import org.arquillian.extension.governor.spi.event.GovernorExtensionConfigured;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class GitHubGovernorConfigurator {
    private static final Logger logger = Logger.getLogger(GitHubGovernorConfigurator.class.getName());
    private static final String EXTENSION_NAME = "governor-github";
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ApplicationScoped
    private InstanceProducer<GitHubGovernorConfiguration> gitHubGovernorConfiguration;
    @Inject
    @ApplicationScoped
    private InstanceProducer<GitHubGovernorClient> gitHubGovernorClient;
    @Inject
    @ApplicationScoped
    private InstanceProducer<GitHubClient> gitHubClient;

    public void onGovernorExtensionConfigured(@Observes GovernorExtensionConfigured event, ArquillianDescriptor arquillianDescriptor) throws Exception {
        GitHubGovernorConfiguration gitHubGovernorConfiguration = new GitHubGovernorConfiguration();
        for (ExtensionDef extension : arquillianDescriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(EXTENSION_NAME)) continue;
            gitHubGovernorConfiguration.setConfiguration(extension.getExtensionProperties());
            gitHubGovernorConfiguration.validate();
            break;
        }
        this.gitHubGovernorConfiguration.set((Object)gitHubGovernorConfiguration);
        GitHubGovernorClient gitHubGovernorClient = new GitHubGovernorClientFactory().build((GitHubGovernorConfiguration)((Object)this.gitHubGovernorConfiguration.get()));
        this.gitHubGovernorClient.set((Object)gitHubGovernorClient);
        this.gitHubClient.set((Object)gitHubGovernorClient.getGitHubClient());
        logger.log(Level.CONFIG, "Configuration of Arquillian GitHub extension:");
        logger.log(Level.CONFIG, gitHubGovernorConfiguration.toString());
    }
}

