/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.impl;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import java.util.Arrays;
import java.util.List;
import org.arquillian.extension.governor.api.GovernorClient;
import org.arquillian.extension.governor.jira.api.Jira;
import org.arquillian.extension.governor.jira.configuration.JiraGovernorConfiguration;
import org.arquillian.extension.governor.jira.impl.JiraGovernorStrategy;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;

public class JiraGovernorClient
implements GovernorClient<Jira, JiraGovernorStrategy> {
    private JiraRestClient restClient;
    private JiraGovernorStrategy jiraGovernorStrategy;
    private JiraGovernorConfiguration jiraGovernorConfiguration;
    private int JIRA_BUILD_NUMBER = 0;

    public void setConfiguration(JiraGovernorConfiguration jiraGovernorConfiguration) {
        Validate.notNull((Object)((Object)jiraGovernorConfiguration), (String)"Jira Governor configuration must be specified.");
        this.jiraGovernorConfiguration = jiraGovernorConfiguration;
    }

    public ExecutionDecision resolve(Jira annotation) {
        Validate.notNull((Object)this.restClient, (String)"Jira REST client must be specified.");
        Validate.notNull((Object)this.jiraGovernorStrategy, (String)"Governor strategy must be specified. Have you already called setGovernorStrategy()?");
        String jiraIssueKey = annotation.value();
        if (jiraIssueKey == null || jiraIssueKey.length() == 0) {
            return ExecutionDecision.execute();
        }
        Issue jiraIssue = this.getIssue(jiraIssueKey);
        if (jiraIssue == null) {
            return ExecutionDecision.execute();
        }
        return this.jiraGovernorStrategy.annotation(annotation).issue(jiraIssue).resolve();
    }

    public void close(String id) {
        Validate.notNull((Object)this.restClient, (String)"Jira REST client must be specified.");
        try {
            Issue issue = (Issue)this.restClient.getIssueClient().getIssue(id).get();
            Iterable transitions = (Iterable)this.restClient.getIssueClient().getTransitions(issue.getTransitionsUri()).claim();
            Transition resolveIssueTransition = JiraGovernorClient.getTransitionByName(transitions, "Resolve Issue");
            List<FieldInput> fieldInputs = this.JIRA_BUILD_NUMBER > 700 ? Arrays.asList(new FieldInput("resolution", (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)"Done"))) : Arrays.asList(new FieldInput("resolution", (Object)"Done"));
            Comment closingMessage = Comment.valueOf((String)this.getClosingMessage());
            TransitionInput transitionInput = new TransitionInput(resolveIssueTransition.getId(), fieldInputs, closingMessage);
            this.restClient.getIssueClient().transition(issue.getTransitionsUri(), transitionInput).claim();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGovernorStrategy(JiraGovernorStrategy jiraGovernorStrategy) {
        Validate.notNull((Object)jiraGovernorStrategy, (String)"Jira Governor strategy must be specified.");
        this.jiraGovernorStrategy = jiraGovernorStrategy;
    }

    void initializeRestClient(JiraRestClient restClient) throws Exception {
        Validate.notNull((Object)restClient, (String)"Jira REST client must be specified.");
        this.restClient = restClient;
        this.JIRA_BUILD_NUMBER = ((ServerInfo)this.restClient.getMetadataClient().getServerInfo().claim()).getBuildNumber();
    }

    private static Transition getTransitionByName(Iterable<Transition> transitions, String transitionName) {
        for (Transition transition : transitions) {
            if (!transition.getName().equals(transitionName)) continue;
            return transition;
        }
        return null;
    }

    private Issue getIssue(String key) {
        try {
            return (Issue)this.restClient.getIssueClient().getIssue(key).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getClosingMessage() {
        Validate.notNull((Object)((Object)this.jiraGovernorConfiguration), (String)"Jira Governor configuration must be set.");
        return String.format(this.jiraGovernorConfiguration.getClosingMessage(), this.jiraGovernorConfiguration.getUsername());
    }
}

