/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.impl;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.net.URI;
import org.arquillian.extension.governor.api.GovernorClientFactory;
import org.arquillian.extension.governor.jira.configuration.JiraGovernorConfiguration;
import org.arquillian.extension.governor.jira.impl.JiraGovernorClient;
import org.arquillian.extension.governor.jira.impl.JiraGovernorStrategy;
import org.jboss.arquillian.core.spi.Validate;

public class JiraGovernorClientFactory
implements GovernorClientFactory<JiraGovernorConfiguration, JiraGovernorClient> {
    private JiraGovernorConfiguration jiraGovernorConfiguration = null;

    public JiraGovernorClient build(JiraGovernorConfiguration jiraGovernorConfiguration) throws Exception {
        Validate.notNull((Object)((Object)jiraGovernorConfiguration), (String)"Jira governor configuration has to be set.");
        this.jiraGovernorConfiguration = jiraGovernorConfiguration;
        URI jiraServerUri = this.jiraGovernorConfiguration.getServerURI();
        String username = this.jiraGovernorConfiguration.getUsername();
        String password = this.jiraGovernorConfiguration.getPassword();
        AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
        JiraRestClient restClient = factory.createWithBasicHttpAuthentication(jiraServerUri, username, password);
        JiraGovernorClient client = new JiraGovernorClient();
        client.setConfiguration(this.jiraGovernorConfiguration);
        client.initializeRestClient(restClient);
        client.setGovernorStrategy(new JiraGovernorStrategy(jiraGovernorConfiguration));
        return client;
    }
}

