/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.configuration;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.arquillian.extension.governor.api.Configuration;
import org.arquillian.extension.governor.api.GovernorConfigurationException;

public class JiraGovernorConfiguration
extends Configuration {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_JIRA_SERVER_ADDRESS = "https://issues.jboss.org";
    private static final String DEFAULT_JIRA_CLOSING_MESSAGE = "This JIRA issue was automatically closed by %s with Arquillian Governor JIRA extension.";
    private String username = this.resolveUsername();
    private String password = this.resolvePassword();
    private String server = this.resolveServer();
    private boolean force = this.resolveForce();
    private boolean closePassed = this.resolveClosePassed();

    public String getUsername() {
        return this.getProperty("username", this.username);
    }

    public void setUsername(String username) {
        this.setProperty("username", username);
    }

    public String getPassword() {
        return this.getProperty("password", this.password);
    }

    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    public String getServer() {
        return this.getProperty("server", this.server);
    }

    public void setServer(String server) {
        this.setProperty("server", server);
    }

    public boolean getForce() {
        return Boolean.parseBoolean(this.getProperty("force", Boolean.toString(this.force)));
    }

    public void setForce(boolean force) {
        this.setProperty("force", Boolean.toString(force));
    }

    public boolean getClosePassed() {
        return Boolean.parseBoolean(this.getProperty("closePassed", Boolean.toString(this.closePassed)));
    }

    public void setClosePassed(boolean closePassed) {
        this.setProperty("closePassed", Boolean.toString(closePassed));
    }

    public String getClosingMessage() {
        return this.getProperty("closingMessage", DEFAULT_JIRA_CLOSING_MESSAGE);
    }

    public void setClosingMessage(String closingMessage) {
        this.setProperty("closingMessage", closingMessage);
    }

    public URL getServerURL() throws GovernorConfigurationException {
        URL url = null;
        try {
            url = new URL(this.getServer());
        }
        catch (MalformedURLException ex) {
            throw new GovernorConfigurationException("Unable to construct URL of server from address: " + this.getServer());
        }
        return url;
    }

    public URI getServerURI() throws GovernorConfigurationException {
        URI uri = null;
        try {
            uri = new URI(this.getServer());
        }
        catch (URISyntaxException ex) {
            throw new GovernorConfigurationException("Unable to construct URI of server from address: " + this.getServer());
        }
        return uri;
    }

    public void validate() throws GovernorConfigurationException {
        if (this.getServer().length() == 0) {
            throw new GovernorConfigurationException("Server URL is not set - it is an empty String.");
        }
        this.getServerURI();
        this.getServerURL();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "username", this.getUsername()));
        sb.append(String.format("%-40s %s\n", "server", this.getServer()));
        sb.append(String.format("%-40s %s\n", "force", this.getForce()));
        sb.append(String.format("%-40s %s\n", "closePassed", this.getClosePassed()));
        sb.append(String.format("%-40s %s\n", "closingMessage", this.getClosingMessage()));
        return sb.toString();
    }

    private String resolveServer() {
        String server = System.getProperty("jira.governor.server");
        if (server != null && server.length() != 0) {
            return server;
        }
        return DEFAULT_JIRA_SERVER_ADDRESS;
    }

    private String resolvePassword() {
        String password = System.getProperty("jira.governor.password");
        if (password != null && password.length() != 0) {
            return password;
        }
        return EMPTY_STRING;
    }

    private String resolveUsername() {
        String username = System.getProperty("jira.governor.username");
        if (username != null && username.length() != 0) {
            return username;
        }
        return EMPTY_STRING;
    }

    private boolean resolveForce() {
        return Boolean.valueOf(System.getProperty("jira.governor.force"));
    }

    private boolean resolveClosePassed() {
        return Boolean.valueOf(System.getProperty("jira.governor.closepassed"));
    }
}

