/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.impl;

import com.atlassian.jira.rest.client.api.domain.Issue;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.arquillian.extension.governor.api.GovernorStrategy;
import org.arquillian.extension.governor.api.detector.DetectorProcessor;
import org.arquillian.extension.governor.jira.api.Jira;
import org.arquillian.extension.governor.jira.configuration.JiraGovernorConfiguration;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;

public class JiraGovernorStrategy
implements GovernorStrategy {
    public static final String FORCING_EXECUTION_REASON_STRING = "forcing execution";
    public static final String SKIPPING_EXECUTION_REASON_STRING = "Skipping %s. Status %s.";
    public static final String JIRA_CLOSED_STRING = "Closed";
    public static final String JIRA_RESOLVED_STRING = "Resolved";
    private static final Logger logger = Logger.getLogger(JiraGovernorStrategy.class.getName());
    private final JiraGovernorConfiguration jiraGovernorConfiguration;
    private Issue jiraIssue;
    private Jira annotation;

    public JiraGovernorStrategy(JiraGovernorConfiguration jiraGovernorConfiguration) {
        Validate.notNull((Object)((Object)jiraGovernorConfiguration), (String)"Jira Governor configuration has to be set.");
        this.jiraGovernorConfiguration = jiraGovernorConfiguration;
    }

    public JiraGovernorStrategy issue(Issue jiraIssue) {
        this.jiraIssue = jiraIssue;
        return this;
    }

    public JiraGovernorStrategy annotation(Jira annotation) {
        this.annotation = annotation;
        return this;
    }

    public ExecutionDecision resolve() {
        Validate.notNull((Object)this.jiraIssue, (String)"Jira issue must be specified.");
        Validate.notNull((Object)this.annotation, (String)"Annotation must be specified.");
        if (!new DetectorProcessor().process((Annotation)this.annotation)) {
            return ExecutionDecision.execute();
        }
        String jiraStatus = this.jiraIssue.getStatus().getName();
        if (jiraStatus == null || jiraStatus.length() == 0) {
            return ExecutionDecision.execute();
        }
        if (this.annotation.force()) {
            return ExecutionDecision.execute((String)FORCING_EXECUTION_REASON_STRING);
        }
        if (this.jiraGovernorConfiguration.getForce()) {
            return ExecutionDecision.execute((String)FORCING_EXECUTION_REASON_STRING);
        }
        if (jiraStatus.equals(JIRA_CLOSED_STRING) || jiraStatus.equals(JIRA_RESOLVED_STRING)) {
            return ExecutionDecision.execute();
        }
        return ExecutionDecision.dontExecute((String)String.format(SKIPPING_EXECUTION_REASON_STRING, this.jiraIssue.getKey(), jiraStatus));
    }
}

