/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.extension.governor.api.ClosePassedDecider;
import org.arquillian.extension.governor.api.GovernorRegistry;
import org.arquillian.extension.governor.impl.TestMethodExecutionRegister;
import org.arquillian.extension.governor.jira.api.Jira;
import org.arquillian.extension.governor.jira.configuration.JiraGovernorConfiguration;
import org.arquillian.extension.governor.jira.impl.JiraGovernorClient;
import org.arquillian.extension.governor.spi.GovernorProvider;
import org.arquillian.extension.governor.spi.event.ExecutionDecisionEvent;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.AfterTestLifecycleEvent;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;

public class JiraTestExecutionDecider
implements TestExecutionDecider,
GovernorProvider {
    private static final Map<Method, Integer> lifecycleCountRegister = new HashMap<Method, Integer>();
    @Inject
    @ClassScoped
    private InstanceProducer<ExecutionDecision> executionDecision;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ClosePassedDecider> closePassedDecider;

    public ExecutionDecision decide(Method testMethod) {
        return TestMethodExecutionRegister.resolve((Method)testMethod, this.provides());
    }

    public int precedence() {
        return 0;
    }

    public Class<? extends Annotation> provides() {
        return Jira.class;
    }

    public void on(@Observes ExecutionDecisionEvent event, JiraGovernorClient jiraGovernorClient) {
        ExecutionDecision executionDecision = (ExecutionDecision)this.executionDecision.get();
        if (executionDecision == null || executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        if (event.getAnnotation().annotationType() == this.provides()) {
            Jira jiraIssue = (Jira)event.getAnnotation();
            this.executionDecision.set((Object)jiraGovernorClient.resolve(jiraIssue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void on(@Observes AfterTestLifecycleEvent event, TestResult testResult, GovernorRegistry governorRegistry, JiraGovernorConfiguration jiraGovernorConfiguration) {
        block8: {
            int count = 0;
            try {
                Integer c = lifecycleCountRegister.get(event.getTestMethod());
                int n = count = c != null ? c : 0;
                if (count == 0) {
                    return;
                }
                ExecutionDecision decision = TestMethodExecutionRegister.resolve((Method)event.getTestMethod(), this.provides());
                if (!jiraGovernorConfiguration.getClosePassed() || decision.getDecision() != ExecutionDecision.Decision.EXECUTE || !"forcing execution".equals(decision.getReason())) break block8;
                for (Map.Entry entry : governorRegistry.get().entrySet()) {
                    if (!((Method)entry.getKey()).toString().equals(event.getTestMethod().toString())) continue;
                    for (Annotation annotation : (List)entry.getValue()) {
                        if (annotation.annotationType() != this.provides()) continue;
                        ((ClosePassedDecider)this.closePassedDecider.get()).setClosable(annotation, testResult.getStatus() == TestResult.Status.PASSED);
                        return;
                    }
                }
            }
            finally {
                lifecycleCountRegister.put(event.getTestMethod(), ++count);
            }
        }
    }

    public void on(@Observes AfterSuite event, JiraGovernorClient jiraGovernorClient) {
        for (Map.Entry entry : ((ClosePassedDecider)this.closePassedDecider.get()).get().entrySet()) {
            Annotation annotation = (Annotation)entry.getKey();
            if (annotation.annotationType() != this.provides() || !((Boolean)entry.getValue()).booleanValue()) continue;
            String id = ((Jira)annotation).value();
            jiraGovernorClient.close(id);
        }
    }
}

