/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.jira.impl.reporter;

import java.lang.reflect.Method;
import java.util.TreeSet;
import org.arquillian.extension.governor.jira.api.Jira;
import org.arquillian.extension.governor.jira.configuration.JiraGovernorConfiguration;
import org.arquillian.recorder.reporter.PropertyEntry;
import org.arquillian.recorder.reporter.event.PropertyReportEvent;
import org.arquillian.recorder.reporter.model.entry.KeyValueEntry;
import org.arquillian.recorder.reporter.model.entry.table.TableCellEntry;
import org.arquillian.recorder.reporter.model.entry.table.TableEntry;
import org.arquillian.recorder.reporter.model.entry.table.TableRowEntry;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;

public class JiraGovernorRecorder {
    @Inject
    private Instance<JiraGovernorConfiguration> jiraGovernorConfigurationInstance;
    @Inject
    private Event<PropertyReportEvent> propertyReportEvent;

    public void setJiraGovernorConfigurationInstance(Instance<JiraGovernorConfiguration> jiraGovernorConfigurationInstance) {
        this.jiraGovernorConfigurationInstance = jiraGovernorConfigurationInstance;
    }

    public void setPropertyReportEvent(Event<PropertyReportEvent> propertyReportEvent) {
        this.propertyReportEvent = propertyReportEvent;
    }

    public void jiraReportEntries(@Observes After event) {
        Method method = event.getTestMethod();
        TestClass testClass = event.getTestClass();
        String jiraServer = ((JiraGovernorConfiguration)((Object)this.jiraGovernorConfigurationInstance.get())).getServer();
        Jira jira = this.getJiraValue(method, testClass);
        if (jira != null) {
            String issueURL = this.constructJiraIssueURL(jiraServer, jira.value());
            Class[] detectables = jira.detector().value();
            TreeSet<String> uniqDetectables = new TreeSet<String>();
            for (Class detectable : detectables) {
                uniqDetectables.add(detectable.getSimpleName());
            }
            String detectablesName = "";
            for (String detectable : uniqDetectables) {
                detectablesName = detectablesName + (detectablesName == "" ? "" : ",") + detectable;
            }
            TableEntry jiraDetector = new TableEntry();
            jiraDetector.setTableName("JiraOptions");
            jiraDetector.getTableHead().getRow().addCells(new TableCellEntry("Force"), new TableCellEntry[]{new TableCellEntry("Detector Value"), new TableCellEntry("Detector Strategy")});
            TableRowEntry row = new TableRowEntry();
            row.addCells(new TableCellEntry(String.valueOf(jira.force())), new TableCellEntry[]{new TableCellEntry(String.valueOf(jira.detector().strategy().getSimpleName())), new TableCellEntry(detectablesName)});
            jiraDetector.getTableBody().addRow(row);
            this.propertyReportEvent.fire((Object)new PropertyReportEvent((PropertyEntry)new KeyValueEntry("JIRA URL", issueURL)));
            this.propertyReportEvent.fire((Object)new PropertyReportEvent((PropertyEntry)jiraDetector));
        }
    }

    private String constructJiraIssueURL(String server, String issueId) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        String issueURL = server + "browse/" + issueId;
        return issueURL;
    }

    private Jira getJiraValue(Method method, TestClass testClass) {
        Jira jira = method.getAnnotation(Jira.class);
        if (jira == null) {
            jira = (Jira)testClass.getAnnotation(Jira.class);
        }
        return jira;
    }
}

