/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.skipper.impl;

import java.io.File;
import java.util.List;
import org.arquillian.extension.governor.skipper.api.TestSpec;
import org.arquillian.extension.governor.skipper.config.SkipperConfiguration;
import org.arquillian.extension.governor.skipper.impl.AsciidocExporter;
import org.arquillian.extension.governor.skipper.impl.SkipperReportHolder;
import org.arquillian.extension.governor.skipper.impl.TableExporter;
import org.arquillian.recorder.reporter.PropertyEntry;
import org.arquillian.recorder.reporter.ReporterConfiguration;
import org.arquillian.recorder.reporter.event.PropertyReportEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class SkipperReporter {
    @Inject
    private Instance<SkipperReportHolder> holder;
    @Inject
    private Instance<ReporterConfiguration> reporterConfiguration;
    @Inject
    private Instance<SkipperConfiguration> skipperConfiguration;
    @Inject
    private Event<PropertyReportEvent> propertyReportEvent;
    @Inject
    @ApplicationScoped
    private InstanceProducer<AsciidocExporter> asciiDocExporter;

    public void on(@Observes BeforeSuite beforeSuite) {
        SkipperConfiguration skipperConfiguration = (SkipperConfiguration)((Object)this.skipperConfiguration.get());
        ReporterConfiguration reporterConfiguration = (ReporterConfiguration)this.reporterConfiguration.get();
        File adocExportFile = null;
        if (skipperConfiguration.getPlainAdoc() != null) {
            adocExportFile = new File(reporterConfiguration.getFile().getParentFile(), skipperConfiguration.getPlainAdoc());
        }
        if (adocExportFile != null) {
            AsciidocExporter asciidocExporter = new AsciidocExporter(adocExportFile);
            this.asciiDocExporter.set((Object)asciidocExporter);
        }
    }

    public void on(@Observes AfterClass afterClass) {
        List<TestSpec> testSpecs = ((SkipperReportHolder)this.holder.get()).getAll();
        if (this.asciiDocExporter.get() != null) {
            ((AsciidocExporter)this.asciiDocExporter.get()).append(testSpecs, afterClass.getTestClass().getJavaClass().getCanonicalName());
        }
        this.propertyReportEvent.fire((Object)new PropertyReportEvent((PropertyEntry)new TableExporter().constructReportTable(testSpecs)));
        ((SkipperReportHolder)this.holder.get()).clear();
    }

    public void on(@Observes AfterSuite afterSuite) {
        if (this.asciiDocExporter.get() != null) {
            ((AsciidocExporter)this.asciiDocExporter.get()).export();
        }
    }
}

