/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.skipper.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.arquillian.extension.governor.skipper.api.Status;
import org.arquillian.extension.governor.skipper.api.TestSpec;
import org.arquillian.recorder.reporter.model.entry.table.TableCellEntry;
import org.arquillian.recorder.reporter.model.entry.table.TableEntry;
import org.arquillian.recorder.reporter.model.entry.table.TableRowEntry;

public class TableExporter {
    public TableEntry constructReportTable(List<TestSpec> testSpecs) {
        TableEntry tableEntry = new TableEntry();
        TableRowEntry pendingRow = this.constructPendingRow(testSpecs);
        tableEntry.getTableBody().addRow(pendingRow);
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != Status.MANUAL) continue;
            for (TableRowEntry row : this.constructReportRows(testSpec)) {
                tableEntry.getTableBody().addRow(row);
            }
            this.addDummyRow(tableEntry);
        }
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != Status.AUTOMATED) continue;
            for (TableRowEntry row : this.constructReportRows(testSpec)) {
                tableEntry.getTableBody().addRow(row);
            }
            this.addDummyRow(tableEntry);
        }
        return tableEntry;
    }

    private void addDummyRow(TableEntry tableEntry) {
        TableRowEntry dummyRow = new TableRowEntry();
        dummyRow.addCell(new TableCellEntry("---------------"));
        dummyRow.addCell(new TableCellEntry("---------------"));
        tableEntry.getTableBody().addRow(dummyRow);
    }

    private TableRowEntry constructPendingRow(List<TestSpec> testSpecs) {
        TableRowEntry row = new TableRowEntry();
        int pending = 0;
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != Status.MANUAL) continue;
            ++pending;
        }
        row.addCells(new TableCellEntry("pending"), new TableCellEntry[]{new TableCellEntry(String.valueOf(pending + "/" + testSpecs.size()))});
        return row;
    }

    private List<TableRowEntry> constructReportRows(TestSpec testSpec) {
        ArrayList<TableRowEntry> rows = new ArrayList<TableRowEntry>();
        TableRowEntry featureRow = new TableRowEntry();
        featureRow.addCells(new TableCellEntry("feature"), new TableCellEntry[]{new TableCellEntry(testSpec.feature())});
        TableRowEntry testRow = new TableRowEntry();
        testRow.addCells(new TableCellEntry("test"), new TableCellEntry[]{new TableCellEntry(testSpec.test())});
        TableRowEntry prerequisities = new TableRowEntry();
        prerequisities.addCells(new TableCellEntry("prerequisities"), new TableCellEntry[]{new TableCellEntry(testSpec.prerequisites())});
        ArrayList<TableRowEntry> stepRows = new ArrayList<TableRowEntry>();
        ArrayList<String> stepsList = new ArrayList<String>(Arrays.asList(testSpec.steps()));
        if (!stepsList.isEmpty() && !((String)stepsList.get(0)).isEmpty()) {
            TableRowEntry stepRow = new TableRowEntry();
            stepRow.addCells(new TableCellEntry("steps"), new TableCellEntry[]{new TableCellEntry((String)stepsList.get(0))});
            stepRows.add(stepRow);
            stepsList.remove(0);
            for (String step : stepsList) {
                TableRowEntry stepRowEntry = new TableRowEntry();
                stepRowEntry.addCells(new TableCellEntry(""), new TableCellEntry[]{new TableCellEntry(step)});
                stepRows.add(stepRowEntry);
            }
        }
        TableRowEntry assertion = new TableRowEntry();
        assertion.addCells(new TableCellEntry("assertion"), new TableCellEntry[]{new TableCellEntry(testSpec.assertion())});
        TableRowEntry issue = new TableRowEntry();
        issue.addCells(new TableCellEntry("issue"), new TableCellEntry[]{new TableCellEntry(testSpec.issue())});
        TableRowEntry status = new TableRowEntry();
        status.addCells(new TableCellEntry("status"), new TableCellEntry[]{new TableCellEntry(testSpec.status().toString())});
        TableRowEntry author = new TableRowEntry();
        author.addCells(new TableCellEntry("author"), new TableCellEntry[]{new TableCellEntry(testSpec.author())});
        rows.add(featureRow);
        rows.add(testRow);
        rows.add(prerequisities);
        rows.addAll(stepRows);
        rows.add(assertion);
        rows.add(issue);
        rows.add(status);
        rows.add(author);
        return rows;
    }
}

