/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.skipper.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.extension.governor.skipper.config.SkipperConfiguration;
import org.arquillian.extension.governor.skipper.impl.SkipperReportHolder;
import org.arquillian.extension.governor.spi.event.GovernorExtensionConfigured;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class SkipperConfigurator {
    private static final Logger logger = Logger.getLogger(SkipperConfigurator.class.getName());
    private static final String EXTENSION_NAME = "governor-skipper";
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ApplicationScoped
    private InstanceProducer<SkipperConfiguration> skipperConfiguration;
    @Inject
    @ApplicationScoped
    private InstanceProducer<SkipperReportHolder> skipperReportHolder;

    public void onGovernorExtensionConfigured(@Observes GovernorExtensionConfigured event, ArquillianDescriptor arquillianDescriptor) throws Exception {
        SkipperConfiguration skipperConfiguration = new SkipperConfiguration();
        for (ExtensionDef extension : arquillianDescriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(EXTENSION_NAME)) continue;
            skipperConfiguration.setConfiguration(extension.getExtensionProperties());
            skipperConfiguration.validate();
            break;
        }
        this.skipperReportHolder.set((Object)new SkipperReportHolder());
        this.skipperConfiguration.set((Object)skipperConfiguration);
        logger.log(Level.CONFIG, "Configuration of Arquillian Skipper extension:");
        logger.log(Level.CONFIG, skipperConfiguration.toString());
    }
}

