/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.skipper.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.arquillian.extension.governor.skipper.api.Status;
import org.arquillian.extension.governor.skipper.api.TestSpec;

public class AsciidocExporter {
    private final List<String> outputLines = new ArrayList<String>();
    private OutputStream outputStream;
    private BufferedWriter writer;
    private File outputFile;

    public AsciidocExporter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.createWriter();
    }

    public AsciidocExporter(File outputFile) {
        this.outputFile = outputFile;
        this.createWriter();
    }

    private void createWriter() {
        if (this.outputStream != null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
        } else if (this.outputFile != null) {
            try {
                this.writer = new BufferedWriter(new FileWriter(this.outputFile));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to create a writer to file %s.", this.outputFile.getAbsolutePath()), e);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void append(List<TestSpec> testSpecs, String className) {
        int automated = this.getCount(testSpecs, Status.AUTOMATED);
        int manual = this.getCount(testSpecs, Status.MANUAL);
        ArrayList<? extends String> appending = new ArrayList<String>();
        appending.add("---");
        appending.add("[cols=\"2*\", options=\"header\"]");
        appending.add("|===");
        appending.add("|class|" + className);
        appending.add("|automated|" + automated);
        appending.add("|manual|" + manual);
        appending.add("|===");
        for (TestSpec testSpec : this.sortTestSpecs(testSpecs)) {
            appending.addAll(this.reportTestSpec(testSpec));
        }
        this.outputLines.addAll(appending);
    }

    public void export() {
        try {
            for (String line : this.outputLines) {
                this.writer.append(line + "\n");
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to export to asciidoctor.");
        }
    }

    private Collection<? extends String> reportTestSpec(TestSpec testSpec) {
        ArrayList<String> report = new ArrayList<String>();
        report.add("[cols=\"2*\", options=\"header\"]");
        report.add("|===");
        report.add("|feature|" + testSpec.feature());
        report.add("|test|" + testSpec.test());
        report.add("|prerequisities|" + testSpec.prerequisites());
        ArrayList<String> stepsList = new ArrayList<String>(Arrays.asList(testSpec.steps()));
        if (!stepsList.isEmpty() && !((String)stepsList.get(0)).isEmpty()) {
            report.add("|steps|" + (String)stepsList.get(0));
            stepsList.remove(0);
            for (String step : stepsList) {
                report.add("||" + step);
            }
        }
        report.add("|assertion|" + testSpec.assertion());
        report.add("|issue|" + testSpec.issue());
        report.add("|status|" + (Object)((Object)testSpec.status()));
        report.add("|author|" + testSpec.author());
        report.add("|===");
        return report;
    }

    private int getCount(List<TestSpec> testSpecs, Status status) {
        int count = 0;
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != status) continue;
            ++count;
        }
        return count;
    }

    private List<TestSpec> sortTestSpecs(List<TestSpec> testSpecs) {
        ArrayList<TestSpec> sortedTestSpecs = new ArrayList<TestSpec>();
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != Status.MANUAL) continue;
            sortedTestSpecs.add(testSpec);
        }
        for (TestSpec testSpec : testSpecs) {
            if (testSpec.status() != Status.AUTOMATED) continue;
            sortedTestSpecs.add(testSpec);
        }
        return sortedTestSpecs;
    }
}

