/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.skipper.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.arquillian.extension.governor.impl.TestMethodExecutionRegister;
import org.arquillian.extension.governor.skipper.api.Status;
import org.arquillian.extension.governor.skipper.api.TestSpec;
import org.arquillian.extension.governor.skipper.impl.SkipperReportHolder;
import org.arquillian.extension.governor.spi.GovernorProvider;
import org.arquillian.extension.governor.spi.event.ExecutionDecisionEvent;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;

public class SkipperTestExecutionDecider
implements TestExecutionDecider,
GovernorProvider {
    @Inject
    @ClassScoped
    private InstanceProducer<ExecutionDecision> executionDecision;
    @Inject
    private Instance<SkipperReportHolder> holder;

    public ExecutionDecision decide(Method testMethod) {
        return TestMethodExecutionRegister.resolve((Method)testMethod, this.provides());
    }

    public Class<? extends Annotation> provides() {
        return TestSpec.class;
    }

    public void on(@Observes ExecutionDecisionEvent event) {
        ExecutionDecision executionDecision = (ExecutionDecision)this.executionDecision.get();
        if (executionDecision == null || executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        if (event.getAnnotation().annotationType() == this.provides()) {
            TestSpec testSpec = (TestSpec)event.getAnnotation();
            ExecutionDecision decision = testSpec.status() == Status.AUTOMATED ? ExecutionDecision.execute() : ExecutionDecision.dontExecute((String)"Test is supposed to be executed manually.");
            this.executionDecision.set((Object)decision);
            ((SkipperReportHolder)this.holder.get()).put(testSpec);
        }
    }

    public int precedence() {
        return 0;
    }
}

