/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.liferay.remote.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.arquillian.container.liferay.remote.enricher.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class LiferayTestEnricher
implements TestEnricher {
    public void enrich(Object testCase) {
        Field[] declaredFields;
        Class<?> testClass = testCase.getClass();
        for (Field declaredField : declaredFields = testClass.getDeclaredFields()) {
            if (!declaredField.isAnnotationPresent(Inject.class)) continue;
            Inject inject = declaredField.getAnnotation(Inject.class);
            if (inject.value().equals("")) {
                this.injectField(declaredField, null, testCase);
                continue;
            }
            this.injectField(declaredField, inject.value(), testCase);
        }
    }

    public Annotation getAnnotation(Annotation[] annotations, Class<?> annotationClass) {
        for (Annotation current : annotations) {
            if (!annotationClass.isAssignableFrom(current.annotationType())) continue;
            return current;
        }
        return null;
    }

    public Object[] resolve(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            Inject injectAnnotation = (Inject)this.getAnnotation(parameterAnnotations, Inject.class);
            if (injectAnnotation == null) continue;
            parameters[i] = injectAnnotation.value().equals("") ? this.resolve(parameterTypes[i], null, method.getDeclaringClass()) : this.resolve(parameterTypes[i], injectAnnotation.value(), method.getDeclaringClass());
        }
        return parameters;
    }

    private Bundle getBundle(Class<?> testCaseClass) {
        ClassLoader classLoader = testCaseClass.getClassLoader();
        if (classLoader instanceof BundleReference) {
            return ((BundleReference)classLoader).getBundle();
        }
        throw new RuntimeException("Test is not running inside BundleContext");
    }

    private void injectField(Field declaredField, String filterString, Object testCase) {
        Class<?> componentClass = declaredField.getType();
        Object service = this.resolve(componentClass, filterString, testCase.getClass());
        this.setField(declaredField, testCase, service);
    }

    private Object resolve(Class<?> componentClass, String filterString, Class<?> testCaseClass) {
        ServiceReference[] serviceReferences;
        Bundle bundle = this.getBundle(testCaseClass);
        BundleContext bundleContext = bundle.getBundleContext();
        try {
            serviceReferences = bundleContext.getServiceReferences(componentClass.getName(), filterString);
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("Bad Syntax for the filter: " + filterString, ise);
        }
        return bundleContext.getService(serviceReferences[0]);
    }

    private void setField(Field declaredField, Object testCase, Object service) {
        boolean accessible = declaredField.isAccessible();
        declaredField.setAccessible(true);
        try {
            declaredField.set(testCase, service);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        declaredField.setAccessible(accessible);
    }
}

