/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.osgi.remote.activator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ArquillianBundleActivator
implements BundleActivator {
    private static final String _SERVICES = "/META-INF/services";
    private static final Logger logger = Logger.getLogger(ArquillianBundleActivator.class.getName());
    private Set<BundleActivator> bundleActivators;
    private JMXTestRunner testRunner;

    public void start(final BundleContext context) throws Exception {
        JMXTestRunner.TestClassLoader testClassLoader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                return context.getBundle().loadClass(className);
            }
        };
        this.bundleActivators = this.loadActivators();
        for (BundleActivator bundleActivator : this.bundleActivators) {
            bundleActivator.start(context);
        }
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner = new JMXTestRunner(testClassLoader){

            public byte[] runTestMethod(String className, String methodName) {
                BundleAssociation.setBundle((Bundle)context.getBundle());
                BundleContextAssociation.setBundleContext((BundleContext)context);
                return super.runTestMethod(className, methodName);
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        for (BundleActivator bundleActivator : this.bundleActivators) {
            bundleActivator.stop(context);
        }
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private void addBundleActivatorToActivatorsListFromStringLine(Set<BundleActivator> activators, String line) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (line.startsWith("!")) {
            return;
        }
        try {
            Class<?> aClass = classLoader.loadClass(line);
            Class<BundleActivator> bundleActivatorClass = aClass.asSubclass(BundleActivator.class);
            activators.add(bundleActivatorClass.newInstance());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Activator " + line + " class not found", cnfe);
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("Activator " + line + " does not implement expected type " + BundleActivator.class.getCanonicalName(), cce);
        }
        catch (Exception e) {
            throw new IllegalStateException("Activator " + line + " can't be created ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBundleActivatorToActivatorsListFromURL(Set<BundleActivator> activators, URL url) throws IOException {
        InputStream is = url.openStream();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = reader.readLine();
            while (null != line) {
                line = this.skipCommentAndTrim(line);
                this.addBundleActivatorToActivatorsListFromStringLine(activators, line);
                line = reader.readLine();
            }
        }
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            logger.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (!serverArr.isEmpty()) {
            mbeanServer = (MBeanServer)serverArr.get(0);
            logger.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            logger.fine("No MBeanServer, create one ...");
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mbeanServer;
    }

    private Set<BundleActivator> loadActivators() {
        String serviceFile = "/META-INF/services/" + BundleActivator.class.getCanonicalName();
        LinkedHashSet<BundleActivator> activators = new LinkedHashSet<BundleActivator>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                this.addBundleActivatorToActivatorsListFromURL(activators, enumeration.nextElement());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load bundle activators", e);
        }
        return activators;
    }

    private String skipCommentAndTrim(String line) {
        int comment = line.indexOf(35);
        String lineWithoutComment = line;
        if (comment > -1) {
            lineWithoutComment = line.substring(0, comment);
        }
        return lineWithoutComment.trim();
    }
}

