/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.osgi.remote.processor.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.arquillian.container.osgi.remote.processor.service.ManifestManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ManifestManagerImpl
implements ManifestManager {
    @Override
    public Manifest getManifest(JavaArchive javaArchive) throws IOException {
        Node manifestNode = javaArchive.get("META-INF/MANIFEST.MF");
        Asset manifestAsset = manifestNode.getAsset();
        return new Manifest(manifestAsset.openStream());
    }

    @Override
    public Manifest putAttributeValue(Manifest manifest, String attributeName, String ... attributeValue) throws IOException {
        Attributes mainAttributes = manifest.getMainAttributes();
        String attributeValues = mainAttributes.getValue(attributeName);
        HashSet<String> attributeValueSet = new HashSet<String>();
        if (attributeValues != null) {
            attributeValueSet.addAll(Arrays.asList(attributeValues.split(",")));
        }
        attributeValueSet.addAll(Arrays.asList(attributeValue));
        StringBuilder sb = new StringBuilder();
        for (String value : attributeValueSet) {
            sb.append(value);
            sb.append(",");
        }
        if (!attributeValueSet.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        attributeValues = sb.toString();
        mainAttributes.putValue(attributeName, attributeValues);
        return manifest;
    }

    @Override
    public void replaceManifest(Archive archive, Manifest manifest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        manifest.write(baos);
        ByteArrayAsset byteArrayAsset = new ByteArrayAsset(baos.toByteArray());
        archive.delete("META-INF/MANIFEST.MF");
        archive.add((Asset)byteArrayAsset, "META-INF/MANIFEST.MF");
    }
}

