/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.arquillian.rusheye.CommandValidationException;

public class CommandBase {
    @Parameter(names={"-h", "--help"})
    private Boolean help;
    @Parameter(names={"--debug"})
    private Boolean debug;

    public boolean isHelp() {
        return this.help == Boolean.TRUE;
    }

    public boolean isDebug() {
        return this.debug == Boolean.TRUE;
    }

    public void initialize() {
    }

    public void validate() throws CommandValidationException {
    }

    protected boolean isForce() {
        return false;
    }

    protected void printErrorMessage(Exception e) {
        if (this.isDebug()) {
            e.printStackTrace();
        } else {
            System.err.println(e.getMessage());
        }
    }

    protected String validateInputFile(String name, File file) {
        if (file != null) {
            if (!file.exists()) {
                return name + " file '" + file.getPath() + "' does not exists";
            }
            if (!file.canRead()) {
                return name + " file '" + file.getPath() + "' can't be read";
            }
        }
        return null;
    }

    protected String validateOutputFile(String name, File file) {
        if (file != null) {
            if (file.exists() && !this.isForce()) {
                return name + " file '" + file.getPath() + "' already exists (use --force/-f to overwrite)";
            }
            if (file.exists() && !file.canWrite()) {
                return name + " file '" + file.getPath() + "' can't be written";
            }
        }
        return null;
    }

    protected String validateInputDirectory(String name, File directory) {
        if (directory != null) {
            if (!directory.exists()) {
                return name + " directory '" + directory.getPath() + "' doesnt exist)";
            }
            if (!directory.isDirectory()) {
                return name + " directory '" + directory.getPath() + "' isn't directory)";
            }
        }
        return null;
    }

    protected List<String> constructMessages() {
        return new LinkedList<String>(){

            @Override
            public boolean add(String e) {
                if (e == null) {
                    return false;
                }
                return super.add(e);
            }
        };
    }
}

