/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.arquillian.rusheye.CommandBase;
import org.arquillian.rusheye.CommandProcessingException;
import org.arquillian.rusheye.CommandValidationException;
import org.arquillian.rusheye.core.DefaultImageComparator;
import org.arquillian.rusheye.parser.DefaultConfiguration;
import org.arquillian.rusheye.result.ResultEvaluator;
import org.arquillian.rusheye.suite.ComparisonResult;
import org.arquillian.rusheye.suite.Configuration;
import org.arquillian.rusheye.suite.ResultConclusion;

@Parameters(commandDescription="Compares two images with given perceptional settings and masks")
public class CommandCompare
extends CommandBase {
    @Parameter(required=true, arity=2, converter=FileConverter.class, description="<Pattern> and <Sample> to be compared")
    private List<File> files;
    @Parameter(names={"--output", "-O"}, converter=FileConverter.class, description="The difference image as result of comparison")
    private File output;
    @Parameter(names={"--force", "-f"}, description="Force to proceed")
    private boolean force = false;
    private ComparisonResult result;
    private Configuration configuration;
    private ResultConclusion conclusion;

    private File getPatternFile() {
        return this.files.get(0);
    }

    private File getSampleFile() {
        return this.files.get(1);
    }

    @Override
    protected boolean isForce() {
        return this.force;
    }

    public void compare() {
        try {
            BufferedImage pattern = this.loadImage(this.getPatternFile());
            BufferedImage sample = this.loadImage(this.getSampleFile());
            this.configuration = new DefaultConfiguration();
            this.result = new DefaultImageComparator().compare(pattern, sample, this.configuration.getPerception(), this.configuration.getMasks());
            this.conclusion = new ResultEvaluator().evaluate(this.configuration.getPerception(), this.result);
        }
        catch (Exception e) {
            this.printErrorMessage(e);
            System.exit(3);
        }
    }

    public void printResult() {
        System.out.println("Result: " + (Object)((Object)this.conclusion));
    }

    public boolean isOutputSet() {
        return this.output != null;
    }

    public void writeDifferenceImage() {
        try {
            ImageIO.write((RenderedImage)this.result.getDiffImage(), "PNG", this.output);
        }
        catch (Exception e) {
            this.printErrorMessage(e);
            System.exit(3);
        }
    }

    @Override
    public void validate() throws CommandValidationException {
        List<String> messages = this.constructMessages();
        messages.add(this.validateInputFile("Pattern", this.getPatternFile()));
        messages.add(this.validateInputFile("Sample", this.getSampleFile()));
        messages.add(this.validateOutputFile("Output", this.output));
        if (!messages.isEmpty()) {
            throw new CommandValidationException(StringUtils.join(messages, '\n'));
        }
    }

    private BufferedImage loadImage(File file) throws CommandProcessingException {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new CommandProcessingException("Failed to load image from file '" + this.getSampleFile().getPath() + "': " + e.getMessage(), e);
        }
    }
}

