/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.arquillian.rusheye.CommandBase;
import org.arquillian.rusheye.CommandValidationException;
import org.arquillian.rusheye.parser.listener.CompareListener;
import org.arquillian.rusheye.result.collector.ResultCollectorImpl;
import org.arquillian.rusheye.result.statistics.OverallStatistics;
import org.arquillian.rusheye.result.storage.FileStorage;
import org.arquillian.rusheye.result.writer.FileResultWriter;
import org.arquillian.rusheye.retriever.mask.MaskFileRetriever;
import org.arquillian.rusheye.retriever.pattern.PatternFileRetriever;
import org.arquillian.rusheye.retriever.sample.FileSampleRetriever;
import org.arquillian.rusheye.suite.MaskType;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

@Parameters(commandDescription="Crawls the directory with images to create Visual Suite descriptor")
public class CommandCrawl
extends CommandBase {
    @Parameter(converter=FileConverter.class, description="directory with patterns to be crawled")
    private List<File> patterns;
    private File patternBase;
    @Parameter(names={"-m", "--masks"}, converter=FileConverter.class, description="directory with masks (default: current directory)")
    private File maskBase = new File(".");
    @Parameter(names={"--output", "-O"}, converter=FileConverter.class, description="The output of XML (default: written to stdout)")
    private File output;
    @Parameter(names={"--force", "-f"}, description="Force to proceed")
    private boolean force;
    @Parameter(names={"one-pixel-treshold"}, description="")
    private Integer onePixelTreshold;
    @Parameter(names={"global-difference-treshold"}, description="")
    private Integer globalDifferenceTreshold;
    @Parameter(names={"global-difference-amount"}, description="")
    private String globalDifferenceAmount;
    private Document document;
    private Namespace ns;

    @Override
    public void initialize() {
        if (this.patterns != null && this.patterns.size() > 0) {
            this.patternBase = this.patterns.get(0);
        }
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    public void crawl() {
        this.document = DocumentHelper.createDocument();
        this.addDocumentRoot();
        this.writeDocument();
    }

    private void writeDocument() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        OutputStream out = this.openOutputStream();
        try {
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(this.document);
            writer.close();
        }
        catch (IOException e) {
            this.printErrorMessage(e);
            System.exit(7);
        }
    }

    private OutputStream openOutputStream() {
        if (this.output == null) {
            return System.out;
        }
        try {
            return new FileOutputStream(this.output);
        }
        catch (IOException e) {
            this.printErrorMessage(e);
            System.exit(7);
            return null;
        }
    }

    private void addDocumentRoot() {
        this.ns = Namespace.get("http://www.jboss.org/rusheye/visual-suite");
        Element root = this.document.addElement(QName.get("visual-suite", this.ns));
        Namespace xsi = Namespace.get("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        QName schemaLocation = QName.get("schemaLocation", xsi);
        root.addNamespace("", this.ns.getURI());
        root.addNamespace(xsi.getPrefix(), xsi.getURI());
        root.addAttribute(schemaLocation, this.ns.getURI() + " " + "http://www.jboss.org/schema/arquillian/rusheye/visual-suite.xsd");
        Element globalConfiguration = root.addElement(QName.get("global-configuration", this.ns));
        this.addSuiteListener(globalConfiguration);
        this.addRetrievers(globalConfiguration);
        this.addPerception(globalConfiguration);
        this.addMasksByType(this.maskBase, globalConfiguration);
        this.addTests(this.patternBase, root);
    }

    private void addSuiteListener(Element globalConfiguration) {
        Element suiteListener = globalConfiguration.addElement(QName.get("listener", this.ns));
        suiteListener.addAttribute("type", CompareListener.class.getName());
        suiteListener.addElement(QName.get("result-collector", this.ns)).addText(ResultCollectorImpl.class.getName());
        suiteListener.addElement(QName.get("result-storage", this.ns)).addText(FileStorage.class.getName());
        suiteListener.addElement(QName.get("result-writer", this.ns)).addText(FileResultWriter.class.getName());
        suiteListener.addElement(QName.get("result-statistics", this.ns)).addText(OverallStatistics.class.getName());
    }

    private void addRetrievers(Element globalConfiguration) {
        globalConfiguration.addElement(QName.get("pattern-retriever", this.ns)).addAttribute("type", PatternFileRetriever.class.getName());
        globalConfiguration.addElement(QName.get("mask-retriever", this.ns)).addAttribute("type", MaskFileRetriever.class.getName());
        globalConfiguration.addElement(QName.get("sample-retriever", this.ns)).addAttribute("type", FileSampleRetriever.class.getName());
    }

    private void addPerception(Element base) {
        Element perception = base.addElement(QName.get("perception", this.ns));
        if (this.onePixelTreshold != null) {
            perception.addElement(QName.get("one-pixel-treshold", this.ns)).addText(String.valueOf(this.onePixelTreshold));
        }
        if (this.globalDifferenceTreshold != null) {
            perception.addElement(QName.get("global-difference-treshold", this.ns)).addText(String.valueOf(this.globalDifferenceTreshold));
        }
        if (this.globalDifferenceAmount != null) {
            perception.addElement(QName.get("global-difference-amount", this.ns)).addText(this.globalDifferenceAmount);
        }
    }

    private void addMasksByType(File dir, Element base) {
        for (MaskType maskType : MaskType.values()) {
            File maskDir = new File(dir, "masks-" + maskType.value());
            if (!maskDir.exists() || !maskDir.isDirectory() || maskDir.listFiles().length <= 0) continue;
            this.addMasks(maskDir, base, maskType);
        }
    }

    private void addMasks(File dir, Element base, MaskType maskType) {
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String id = StringUtils.substringBeforeLast(file.getName(), ".");
                String source = this.getRelativePath(this.maskBase, file);
                String info = StringUtils.substringAfterLast(id, "--");
                String[] infoTokens = StringUtils.split(info, "-");
                Element mask = base.addElement(QName.get("mask", this.ns)).addAttribute("id", id).addAttribute("type", maskType.value()).addAttribute("source", source);
                for (String alignment : infoTokens) {
                    String attribute = ArrayUtils.contains(new String[]{"top", "bottom"}, alignment) ? "vertical-align" : "horizontal-align";
                    mask.addAttribute(attribute, alignment);
                }
            }
        }
    }

    private void addTests(File dir, Element root) {
        if (dir.exists() && dir.isDirectory()) {
            block0: for (File testFile : dir.listFiles()) {
                String name;
                for (MaskType mask : MaskType.values()) {
                    if (testFile.getName().equals("masks-" + mask.value())) continue block0;
                }
                if (testFile.isDirectory() && testFile.listFiles().length > 0) {
                    name = testFile.getName();
                    Element test = root.addElement(QName.get("test", this.ns));
                    test.addAttribute("name", name);
                    this.addPatterns(testFile, test);
                    this.addMasksByType(testFile, test);
                }
                if (!testFile.isFile()) continue;
                name = StringUtils.substringBeforeLast(testFile.getName(), ".");
                Element test = root.addElement(QName.get("test", this.ns));
                test.addAttribute("name", name);
                String source = this.getRelativePath(this.patternBase, testFile);
                Element pattern = test.addElement(QName.get("pattern", this.ns));
                pattern.addAttribute("name", name);
                pattern.addAttribute("source", source);
            }
        }
    }

    private void addPatterns(File dir, Element test) {
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                String name = StringUtils.substringBeforeLast(file.getName(), ".");
                String source = this.getRelativePath(this.patternBase, file);
                Element pattern = test.addElement(QName.get("pattern", this.ns));
                pattern.addAttribute("name", name);
                pattern.addAttribute("source", source);
            }
        }
    }

    private String getRelativePath(File base, File file) {
        return StringUtils.substringAfter(file.getPath(), base.getPath()).replaceFirst("^/", "");
    }

    @Override
    public void validate() throws CommandValidationException {
        List<String> messages = this.constructMessages();
        messages.add(this.validateInputDirectory("Base", this.patternBase));
        messages.add(this.validateOutputFile("Output", this.output));
        messages.add(this.validateOnePixelTreshold());
        messages.add(this.validateGlobalDifferenceTreshold());
        messages.add(this.validateGlobalDifferenceAmount());
        if (!messages.isEmpty()) {
            throw new CommandValidationException(StringUtils.join(messages, '\n'));
        }
    }

    private String validateOnePixelTreshold() {
        if (this.onePixelTreshold != null && (this.onePixelTreshold < 0 || this.onePixelTreshold > 768)) {
            return "One pixel treshold must be integer in range 0-768";
        }
        return null;
    }

    private String validateGlobalDifferenceTreshold() {
        if (this.globalDifferenceTreshold != null && (this.globalDifferenceTreshold < 0 || this.globalDifferenceTreshold > 768)) {
            return "Global difference treshold must be integer in range 0-768";
        }
        return null;
    }

    private String validateGlobalDifferenceAmount() {
        if (this.globalDifferenceAmount != null) {
            Pattern[] pixelAmountPatterns;
            boolean matches = false;
            for (Pattern pattern : pixelAmountPatterns = new Pattern[]{Pattern.compile("\\d+px"), Pattern.compile("([0-9]{1,2}|100)%")}) {
                if (!pattern.matcher(this.globalDifferenceAmount).matches()) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return "Global difference pixel must be amount of pixels perceptually different - % of image surface or integer of pixels differ";
            }
        }
        return null;
    }
}

