/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.arquillian.rusheye.CommandBase;
import org.arquillian.rusheye.CommandValidationException;
import org.arquillian.rusheye.internal.Instantiator;
import org.arquillian.rusheye.listener.SuiteListener;
import org.arquillian.rusheye.parser.Parser;
import org.arquillian.rusheye.suite.Properties;

@Parameters(commandDescription="Parse the Visual Suite descriptor in order to run comparison process")
public class CommandParse
extends CommandBase {
    @Parameter(required=true, arity=1, description="The Visual Suite descriptor", converter=FileConverter.class)
    private List<File> files;
    @Parameter(names={"--listener", "-L"}, description="Main listener used to proceed comparison", converter=SuiteListenerConverter.class)
    private SuiteListener suiteListener;
    @Parameter(names={"-D"}, description="Defines properties to listeners proceeding comparison")
    private List<String> definitions;
    @Parameter(names={"--output", "-O"}, description="Visual Suite Result descriptor output filename")
    private File output;
    @Parameter(names={"--force", "-f"}, description="Force to proceed")
    private boolean force = false;
    private File input;
    private Properties properties = new Properties();

    public void parse() {
        try {
            Parser parser = new Parser();
            parser.setProperties(this.properties);
            if (this.suiteListener != null) {
                parser.registerListener(this.suiteListener);
            }
            parser.parseFile(this.input);
        }
        catch (Exception e) {
            this.printErrorMessage(e);
            System.exit(100);
        }
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void initialize() {
        this.input = this.files.get(0);
        if (this.definitions != null) {
            for (String definition : this.definitions) {
                String key = StringUtils.substringBefore(definition, "=");
                String value = StringUtils.substringAfter(definition, "=");
                this.properties.setProperty(key, value);
            }
        }
    }

    @Override
    public void validate() throws CommandValidationException {
        List<String> messages = this.constructMessages();
        messages.add(this.validateInputFile("Visual Suite", this.input));
        messages.add(this.validateOutputFile("Output", this.output));
        if (!messages.isEmpty()) {
            throw new CommandValidationException(StringUtils.join(messages, '\n'));
        }
    }

    public class SuiteListenerConverter
    implements IStringConverter<SuiteListener> {
        @Override
        public SuiteListener convert(String type) {
            return (SuiteListener)new Instantiator().getInstance(type);
        }
    }
}

