/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import org.arquillian.rusheye.CommandBase;
import org.arquillian.rusheye.CommandCompare;
import org.arquillian.rusheye.CommandCrawl;
import org.arquillian.rusheye.CommandParse;
import org.arquillian.rusheye.CommandValidationException;
import org.arquillian.rusheye.Commander;
import org.xml.sax.SAXException;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws SAXException, IOException {
        Commander cm = new Commander();
        try {
            cm.parse(args);
        }
        catch (ParameterException e) {
            Main.printUsageMessage(cm, e);
            System.exit(1);
        }
        Object base = cm.getCommand();
        JCommander jc = cm.getJCommander();
        if (base.getClass() == CommandBase.class) {
            jc.usage();
        } else {
            if (((CommandBase)base).isHelp()) {
                jc.usage();
                System.exit(0);
            }
            ((CommandBase)base).initialize();
            try {
                ((CommandBase)base).validate();
            }
            catch (CommandValidationException e) {
                Main.printUsageMessage(cm, e);
                System.exit(2);
            }
            if (base instanceof CommandCompare) {
                CommandCompare commandCompare = (CommandCompare)base;
                commandCompare.compare();
                commandCompare.printResult();
                if (commandCompare.isOutputSet()) {
                    commandCompare.writeDifferenceImage();
                }
            }
            if (base instanceof CommandCrawl) {
                CommandCrawl commandCrawl = (CommandCrawl)base;
                commandCrawl.crawl();
            }
            if (base instanceof CommandParse) {
                CommandParse commandParse = (CommandParse)base;
                commandParse.parse();
            }
        }
    }

    private static void printUsageMessage(Commander cm, Exception e) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(e.getMessage() + "\n\n");
        cm.getJCommander().usage(errorMsg);
        System.err.println(errorMsg);
    }
}

