/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.core;

import java.awt.color.ColorSpace;
import org.arquillian.rusheye.core.ColorDistance;
import org.arquillian.rusheye.core.ColorModelRGBA;
import org.arquillian.rusheye.core.ColorSpaceLAB;

public class ColorDistanceLAB
implements ColorDistance {
    ColorSpace colorSpaceLAB = new ColorSpaceLAB();

    @Override
    public float getDistance(int color1, int color2) {
        if (color1 == color2) {
            return 0.0f;
        }
        float[] rgb1 = ColorModelRGBA.getRGB(color1);
        float[] rgb2 = ColorModelRGBA.getRGB(color2);
        float[] cieLab1 = this.colorSpaceLAB.fromRGB(rgb1);
        float[] cieLab2 = this.colorSpaceLAB.fromRGB(rgb2);
        return this.getDistance(cieLab1, cieLab2);
    }

    private float getDistance(float[] cieLab1, float[] cieLab2) {
        double suma = 0.0;
        for (int i = 0; i < 3; ++i) {
            float delta = Math.abs(cieLab1[i] - cieLab2[i]);
            suma += Math.pow(delta, 2.0);
        }
        return new Double(Math.sqrt(suma)).floatValue();
    }
}

