/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.core;

import java.awt.Color;

public final class ColorModelRGBA {
    static final int ALPHA_MASK = -16777216;
    static final int RED_MASK = 0xFF0000;
    static final int GREEN_MASK = 65280;
    static final int BLUE_MASK = 255;
    static final int RED_SHIFT = 16;
    static final int GREEN_SHIFT = 8;
    static final int BLUE_SHIFT = 0;

    private ColorModelRGBA() {
    }

    static int getR(int color) {
        return ColorModelRGBA.colorComponent(color, 0xFF0000, 16);
    }

    static int getG(int color) {
        return ColorModelRGBA.colorComponent(color, 65280, 8);
    }

    static int getB(int color) {
        return ColorModelRGBA.colorComponent(color, 255, 0);
    }

    static Color rgb2grayscale(int color) {
        int r = ColorModelRGBA.getR(color);
        int g = ColorModelRGBA.getG(color);
        int b = ColorModelRGBA.getB(color);
        float gray = (0.3f * (float)r + 0.59f * (float)g + 0.11f * (float)b) / 255.0f;
        return new Color(gray, gray, gray);
    }

    static float[] getRGB(int color) {
        return new float[]{ColorModelRGBA.getR(color), ColorModelRGBA.getG(color), ColorModelRGBA.getB(color)};
    }

    private static int colorComponent(int color, int mask, int shift) {
        return (color & mask) >> shift;
    }
}

