/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.core;

import java.awt.color.ColorSpace;
import org.arquillian.rusheye.core.ColorSpaceXYZ;

public class ColorSpaceLAB
extends ColorSpace {
    private static final long serialVersionUID = 1L;
    private static final double REF_X = (double)95.047f;
    private static final double REF_Y = 100.0;
    private static final double REF_Z = (double)108.883f;

    protected ColorSpaceLAB() {
        super(1, 3);
    }

    public static ColorSpaceLAB getInstance() {
        return new ColorSpaceLAB();
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        ColorSpaceXYZ cieXYZSpace = ColorSpaceXYZ.getInstance();
        float[] cieXYZ = ((ColorSpace)cieXYZSpace).fromRGB(rgbvalue);
        double x = cieXYZ[0];
        double y = cieXYZ[1];
        double z = cieXYZ[2];
        x /= (double)95.047f;
        y /= 100.0;
        z /= (double)108.883f;
        x = this.transform(x);
        y = this.transform(y);
        z = this.transform(z);
        Double l = 116.0 * y - 16.0;
        Double a = 500.0 * (x - y);
        Double b = 200.0 * (y - z);
        float[] cieLAB = new float[cieXYZ.length];
        cieLAB[0] = l.floatValue();
        cieLAB[1] = a.floatValue();
        cieLAB[2] = b.floatValue();
        for (int i = 3; i < cieXYZ.length; ++i) {
            cieXYZ[i] = cieXYZ[i];
        }
        return cieLAB;
    }

    private double transform(double base) {
        Double d = new Double(base);
        d = d > 0.008856 ? Double.valueOf(Math.pow(d, 0.3333333333333333)) : Double.valueOf(7.787 * d + 0.13793103448275862);
        return d.floatValue();
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }
}

