/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.core;

import java.awt.color.ColorSpace;

public class ColorSpaceXYZ
extends ColorSpace {
    private static final long serialVersionUID = 1L;

    protected ColorSpaceXYZ() {
        super(0, 3);
    }

    public static ColorSpaceXYZ getInstance() {
        return new ColorSpaceXYZ();
    }

    @Override
    public float[] fromRGB(float[] sRGB) {
        double[] c = new double[3];
        int i = 0;
        while (i < 3) {
            c[i] = sRGB[i];
            int n = i;
            c[n] = c[n] / 255.0;
            if (c[i] <= 0.03982) {
                int n2 = i;
                c[n2] = c[n2] / 12.92;
            } else {
                c[i] = Math.pow((c[i] + 0.055) / 1.055, 2.4);
            }
            int n3 = i++;
            c[n3] = c[n3] * 100.0;
        }
        Double x = c[0] * 0.4124 + c[1] * 0.3576 + c[2] * 0.1805;
        Double y = c[0] * 0.2126 + c[1] * 0.7152 + c[2] * 0.0722;
        Double z = c[0] * 0.0193 + c[1] * 0.1192 + c[2] * 0.9505;
        float[] cieXYZ = new float[sRGB.length];
        cieXYZ[0] = x.floatValue();
        cieXYZ[1] = y.floatValue();
        cieXYZ[2] = z.floatValue();
        for (int i2 = 3; i2 < sRGB.length; ++i2) {
            cieXYZ[i2] = sRGB.length;
        }
        return cieXYZ;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        throw new UnsupportedOperationException("unsupported operation");
    }
}

